/*
 * Decompiled with CFR 0.152.
 */
package re.belv.croiseur.gui.presenter;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import re.belv.croiseur.common.dictionary.DictionaryProviderDetails;
import re.belv.croiseur.common.dictionary.ProvidedDictionaryDetails;
import re.belv.croiseur.common.puzzle.PuzzleCodecDetails;
import re.belv.croiseur.common.puzzle.SavedPuzzle;
import re.belv.croiseur.gui.presenter.GuiCluePresenter;
import re.belv.croiseur.gui.presenter.GuiDictionaryPresenter;
import re.belv.croiseur.gui.presenter.GuiPuzzlePresenter;
import re.belv.croiseur.gui.presenter.GuiSolverPresenter;
import re.belv.croiseur.gui.view.model.ApplicationViewModel;
import re.belv.croiseur.spi.presenter.Presenter;
import re.belv.croiseur.spi.presenter.clue.ClueProviderDescription;
import re.belv.croiseur.spi.presenter.dictionary.DictionaryContent;
import re.belv.croiseur.spi.presenter.dictionary.DictionarySearchResult;
import re.belv.croiseur.spi.presenter.solver.SolverDescription;
import re.belv.croiseur.spi.presenter.solver.SolverInitialisationState;
import re.belv.croiseur.spi.presenter.solver.SolverProgress;
import re.belv.croiseur.spi.presenter.solver.SolverResult;

public final class GuiPresenter
implements Presenter {
    private final GuiDictionaryPresenter dictionaryPresenter;
    private final GuiSolverPresenter solverPresenter;
    private final GuiCluePresenter cluePresenter;
    private final GuiPuzzlePresenter puzzlePresenter;

    public GuiPresenter(ApplicationViewModel applicationViewModel) {
        this.dictionaryPresenter = new GuiDictionaryPresenter(applicationViewModel.dictionaryViewModel(), applicationViewModel.errorsViewModel());
        this.solverPresenter = new GuiSolverPresenter(applicationViewModel.crosswordGridViewModel(), applicationViewModel.solverConfigurationViewModel(), applicationViewModel.solverProgressViewModel(), applicationViewModel.errorsViewModel());
        this.cluePresenter = new GuiCluePresenter(applicationViewModel.cluesViewModel(), applicationViewModel.crosswordGridViewModel(), applicationViewModel.errorsViewModel());
        this.puzzlePresenter = new GuiPuzzlePresenter(applicationViewModel.puzzleSelectionViewModel(), applicationViewModel.puzzleEditionViewModel(), applicationViewModel.puzzleCodecsViewModel(), applicationViewModel.errorsViewModel());
    }

    public void presentAvailableSolvers(List<SolverDescription> solverDescriptions) {
        this.solverPresenter.presentAvailableSolvers(solverDescriptions);
    }

    public void presentSolverInitialisationState(SolverInitialisationState solverInitialisationState) {
        this.solverPresenter.presentSolverInitialisationState(solverInitialisationState);
    }

    public void presentSolverProgress(SolverProgress solverProgress) {
        this.solverPresenter.presentSolverProgress(solverProgress);
    }

    public void presentSolverResult(SolverResult result) {
        this.solverPresenter.presentSolverResult(result);
    }

    public void presentSolverError(String error) {
        this.solverPresenter.presentSolverError(error);
    }

    public void presentDictionaryProviders(Collection<DictionaryProviderDetails> providers) {
        this.dictionaryPresenter.presentDictionaryProviders(providers);
    }

    public void presentDictionaries(List<ProvidedDictionaryDetails> dictionaries) {
        this.dictionaryPresenter.presentDictionaries(dictionaries);
    }

    public void presentDictionaryEntries(DictionaryContent content) {
        this.dictionaryPresenter.presentDictionaryEntries(content);
    }

    public void presentDictionarySearchResult(DictionarySearchResult searchResult) {
        this.dictionaryPresenter.presentDictionarySearchResult(searchResult);
    }

    public void presentDefaultDictionary(ProvidedDictionaryDetails defaultDictionary) {
        this.dictionaryPresenter.presentDefaultDictionary(defaultDictionary);
    }

    public void presentDictionaryError(String error) {
        this.dictionaryPresenter.presentDictionaryError(error);
    }

    public void presentAvailablePuzzles(List<SavedPuzzle> puzzles) {
        this.puzzlePresenter.presentAvailablePuzzles(puzzles);
    }

    public void presentLoadedPuzzle(SavedPuzzle puzzle) {
        this.puzzlePresenter.presentLoadedPuzzle(puzzle);
    }

    public void presentPuzzleRepositoryError(String error) {
        this.puzzlePresenter.presentPuzzleRepositoryError(error);
    }

    public void presentSavedPuzzle(SavedPuzzle puzzle) {
        this.puzzlePresenter.presentSavedPuzzle(puzzle);
    }

    public void presentDeletedAllPuzzles() {
        this.puzzlePresenter.presentDeletedAllPuzzles();
    }

    public void presentDeletedPuzzle(long id) {
        this.puzzlePresenter.presentDeletedPuzzle(id);
    }

    public void presentPuzzleDecoders(List<PuzzleCodecDetails> decoders) {
        this.puzzlePresenter.presentPuzzleDecoders(decoders);
    }

    public void presentPuzzleImportError(String error) {
        this.puzzlePresenter.presentPuzzleImportError(error);
    }

    public void presentPuzzleEncoders(List<PuzzleCodecDetails> encoders) {
        this.puzzlePresenter.presentPuzzleEncoders(encoders);
    }

    public void presentPuzzleExportError(String error) {
        this.puzzlePresenter.presentPuzzleExportError(error);
    }

    public void presentClueError(String error) {
        this.cluePresenter.presentClueError(error);
    }

    public void presentClueProviders(List<ClueProviderDescription> clueProviderDescriptions) {
        this.cluePresenter.presentClueProviders(clueProviderDescriptions);
    }

    public void presentClues(Map<String, String> clues) {
        this.cluePresenter.presentClues(clues);
    }
}

