/*
 * Decompiled with CFR 0.152.
 */
package re.belv.croiseur.gui.controller.puzzle;

import java.io.File;
import java.util.concurrent.Executor;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.concurrent.Task;
import re.belv.croiseur.api.puzzle.PuzzleService;
import re.belv.croiseur.gui.controller.puzzle.DeleteSelectedPuzzleTask;
import re.belv.croiseur.gui.controller.puzzle.ExportPuzzleTask;
import re.belv.croiseur.gui.controller.puzzle.ImportPuzzleTask;
import re.belv.croiseur.gui.controller.puzzle.ListPuzzleDecodersTask;
import re.belv.croiseur.gui.controller.puzzle.ListPuzzleEncodersTask;
import re.belv.croiseur.gui.controller.puzzle.ListPuzzlesTask;
import re.belv.croiseur.gui.controller.puzzle.LoadSelectedPuzzleTask;
import re.belv.croiseur.gui.controller.puzzle.SavePuzzleTask;
import re.belv.croiseur.gui.view.model.PuzzleEditionViewModel;
import re.belv.croiseur.gui.view.model.PuzzleSelectionViewModel;

public final class PuzzleController {
    private static final Logger LOGGER = Logger.getLogger(PuzzleController.class.getName());
    private final PuzzleSelectionViewModel puzzleSelectionViewModel;
    private final PuzzleEditionViewModel puzzleEditionViewModel;
    private final PuzzleService puzzleService;
    private final Executor executor;

    public PuzzleController(PuzzleSelectionViewModel puzzleSelectionViewModelArg, PuzzleEditionViewModel puzzleEditionViewModelArg, PuzzleService puzzleServiceArg, Executor executorArg) {
        this.puzzleSelectionViewModel = puzzleSelectionViewModelArg;
        this.puzzleEditionViewModel = puzzleEditionViewModelArg;
        this.puzzleService = puzzleServiceArg;
        this.executor = executorArg;
    }

    public void listPuzzles() {
        ListPuzzlesTask task = new ListPuzzlesTask(this.puzzleService.persistence());
        this.execute(task);
    }

    public void listPuzzleDecoders() {
        ListPuzzleDecodersTask task = new ListPuzzleDecodersTask(this.puzzleService.importer());
        this.execute(task);
    }

    public void listPuzzleEncoders() {
        ListPuzzleEncodersTask task = new ListPuzzleEncodersTask(this.puzzleService.exporter());
        this.execute(task);
    }

    public void loadSelectedPuzzle() {
        LoadSelectedPuzzleTask task = new LoadSelectedPuzzleTask(this.puzzleSelectionViewModel, this.puzzleService.persistence());
        this.execute(task);
    }

    public void deleteSelectedPuzzle() {
        DeleteSelectedPuzzleTask task = new DeleteSelectedPuzzleTask(this.puzzleSelectionViewModel, this.puzzleService.persistence());
        this.execute(task);
    }

    public void savePuzzle() {
        SavePuzzleTask task = new SavePuzzleTask(this.puzzleEditionViewModel, this.puzzleService.persistence());
        this.execute(task);
    }

    public void importPuzzle(File selectedFile, String selectedFormat) {
        ImportPuzzleTask task = new ImportPuzzleTask(selectedFile, selectedFormat, this.puzzleService.importer());
        this.execute(task);
    }

    public void exportPuzzle(File selectedFile, String selectedFormat) {
        ExportPuzzleTask task = new ExportPuzzleTask(this.puzzleEditionViewModel, selectedFile, selectedFormat, this.puzzleService.exporter());
        this.execute(task);
    }

    private void execute(Task<Void> task) {
        task.setOnFailed(event -> LOGGER.log(Level.WARNING, "Puzzle task failed.", task.getException()));
        this.executor.execute((Runnable)task);
    }
}

