/*
 * Decompiled with CFR 0.152.
 */
package re.belv.croiseur.gui.view.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.OptionalInt;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyIntegerProperty;
import javafx.beans.property.ReadOnlyIntegerWrapper;
import javafx.beans.property.ReadOnlyListProperty;
import javafx.beans.property.ReadOnlyListWrapper;
import javafx.beans.property.ReadOnlyMapProperty;
import javafx.beans.property.ReadOnlyMapWrapper;
import javafx.beans.property.ReadOnlyStringProperty;
import javafx.beans.property.ReadOnlyStringWrapper;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableIntegerValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.MapChangeListener;
import javafx.collections.ObservableList;
import javafx.collections.ObservableMap;
import re.belv.croiseur.gui.view.model.CrosswordBoxViewModel;
import re.belv.croiseur.gui.view.model.GridCoord;
import re.belv.croiseur.gui.view.model.slot.SlotOutline;
import re.belv.croiseur.gui.view.model.slot.SlotsViewModel;

public final class CrosswordGridViewModel {
    private static final int MAX_ROW_COLUMN_COUNT = 20;
    private static final int WELCOME_GRID_COLUMN_COUNT = 6;
    private static final int WELCOME_GRID_ROW_COUNT = 7;
    private final ObservableMap<GridCoord, CrosswordBoxViewModel> boxes;
    private final ReadOnlyMapWrapper<GridCoord, CrosswordBoxViewModel> boxesProperty;
    private final ReadOnlyIntegerWrapper columnCount;
    private final ReadOnlyIntegerWrapper rowCount;
    private final SlotsViewModel slotsViewModel;
    private final WorkingArea workingArea;
    private boolean inhibitContentChangeEvents;

    private CrosswordGridViewModel(Map<GridCoord, CrosswordBoxViewModel> boxesArg, int columnCountArg, int rowCountArg) {
        this.boxes = FXCollections.observableMap(boxesArg);
        this.boxesProperty = new ReadOnlyMapWrapper((Object)this, "boxes", FXCollections.unmodifiableObservableMap(this.boxes));
        this.columnCount = new ReadOnlyIntegerWrapper((Object)this, "columnCount", columnCountArg);
        this.rowCount = new ReadOnlyIntegerWrapper((Object)this, "rowCount", rowCountArg);
        this.slotsViewModel = new SlotsViewModel(this.boxes, (ObservableIntegerValue)this.columnCount, (ObservableIntegerValue)this.rowCount);
        this.workingArea = new WorkingArea(this);
    }

    public static CrosswordGridViewModel newGrid() {
        return new CrosswordGridViewModel(new HashMap<GridCoord, CrosswordBoxViewModel>(), 0, 0);
    }

    public static CrosswordGridViewModel welcomeGrid() {
        HashMap<GridCoord, CrosswordBoxViewModel> welcomeBoxes = new HashMap<GridCoord, CrosswordBoxViewModel>();
        for (int i = 0; i < 6; ++i) {
            for (int j = 0; j < 7; ++j) {
                welcomeBoxes.put(new GridCoord(i, j), new CrosswordBoxViewModel());
            }
        }
        return new CrosswordGridViewModel(welcomeBoxes, 6, 7);
    }

    public ReadOnlyMapProperty<GridCoord, CrosswordBoxViewModel> boxesProperty() {
        return this.boxesProperty.getReadOnlyProperty();
    }

    public CrosswordBoxViewModel box(GridCoord position) {
        return (CrosswordBoxViewModel)this.boxesProperty.get((Object)position);
    }

    public ReadOnlyIntegerProperty columnCountProperty() {
        return this.columnCount.getReadOnlyProperty();
    }

    public int columnCount() {
        return this.columnCount.get();
    }

    public ReadOnlyIntegerProperty rowCountProperty() {
        return this.rowCount.getReadOnlyProperty();
    }

    public int rowCount() {
        return this.rowCount.get();
    }

    public ReadOnlyListProperty<SlotOutline> acrossSlotsProperty() {
        return this.slotsViewModel.acrossSlotsProperty();
    }

    public ObservableList<SlotOutline> longAcrossSlots() {
        return this.slotsViewModel.longAcrossSlots();
    }

    public List<String> longAcrossSlotContents() {
        return this.slotContentsOf((List<SlotOutline>)this.slotsViewModel.longAcrossSlots());
    }

    public OptionalInt indexOfLongAcrossSlotContaining(GridCoord coord) {
        return this.slotsViewModel.indexOfLongAcrossSlotContaining(coord);
    }

    public ReadOnlyListProperty<SlotOutline> downSlotsProperty() {
        return this.slotsViewModel.downSlotsProperty();
    }

    public ObservableList<SlotOutline> longDownSlots() {
        return this.slotsViewModel.longDownSlots();
    }

    public List<String> longDownSlotContents() {
        return this.slotContentsOf((List<SlotOutline>)this.slotsViewModel.longDownSlots());
    }

    public OptionalInt indexOfLongDownSlotContaining(GridCoord coord) {
        return this.slotsViewModel.indexOfLongDownSlotContaining(coord);
    }

    public ObjectProperty<GridCoord> currentBoxPositionProperty() {
        return this.workingArea.currentBoxPosition;
    }

    public void currentBoxPosition(GridCoord position) {
        this.workingArea.currentBoxPosition.set((Object)position);
    }

    public GridCoord currentBoxPosition() {
        return (GridCoord)this.workingArea.currentBoxPosition.get();
    }

    public ReadOnlyListProperty<GridCoord> currentSlotPositionsProperty() {
        return this.workingArea.currentSlotPositions.getReadOnlyProperty();
    }

    public List<GridCoord> currentSlotPositions() {
        return (List)this.currentSlotPositionsProperty().get();
    }

    public ReadOnlyStringProperty currentSlotContentProperty() {
        return this.workingArea.currentSlotContent.getReadOnlyProperty();
    }

    public String currentSlotContent() {
        return this.workingArea.currentSlotContent.get();
    }

    public void currentSlotContent(String value) {
        Objects.requireNonNull(value);
        if (value.length() != this.workingArea.currentSlotContent.length().get()) {
            throw new IllegalArgumentException("Given value does not match current slot size");
        }
        this.inhibitContentChangeEvents = true;
        for (int i = 0; i < value.length(); ++i) {
            ((CrosswordBoxViewModel)this.boxes.get(this.workingArea.currentSlotPositions.get(i))).userContent(value.substring(i, i + 1));
        }
        this.inhibitContentChangeEvents = false;
        this.workingArea.recomputeCurrentSlotContent();
    }

    public BooleanProperty currentSlotVerticalProperty() {
        return this.workingArea.currentSlotVertical;
    }

    public void currentSlotVertical() {
        this.workingArea.currentSlotVertical.set(true);
    }

    public void currentSlotHorizontal() {
        this.workingArea.currentSlotVertical.set(false);
    }

    public BooleanProperty currentSlotUnsolvableProperty() {
        return this.workingArea.currentSlotUnsolvable;
    }

    public void currentSlotUnsolvable() {
        this.workingArea.currentSlotUnsolvable.set(true);
    }

    public void addColumn() {
        int newColumnIndex = this.columnCount.get();
        if (newColumnIndex >= 20) {
            return;
        }
        int currentRowCount = this.rowCount.get();
        for (int row = 0; row < currentRowCount || row == 0; ++row) {
            GridCoord coordinate = new GridCoord(newColumnIndex, row);
            this.boxes.put((Object)coordinate, (Object)new CrosswordBoxViewModel());
        }
        this.columnCount.set(this.columnCount.get() + 1);
        if (currentRowCount == 0) {
            this.rowCount.set(1);
        }
    }

    public void addRow() {
        int newRowIndex = this.rowCount.get();
        if (newRowIndex >= 20) {
            return;
        }
        int currentColumnCount = this.columnCount.get();
        for (int column = 0; column < currentColumnCount || column == 0; ++column) {
            GridCoord coordinate = new GridCoord(column, newRowIndex);
            this.boxes.put((Object)coordinate, (Object)new CrosswordBoxViewModel());
        }
        this.rowCount.set(this.rowCount.get() + 1);
        if (currentColumnCount == 0) {
            this.columnCount.set(1);
        }
    }

    public void deleteLastRow() {
        int oldRowCount = this.rowCount.get();
        if (oldRowCount == 0) {
            return;
        }
        int deletedRowIndex = oldRowCount - 1;
        int currentColumnCount = this.columnCount.get();
        for (int column = 0; column < currentColumnCount; ++column) {
            GridCoord coordinate = new GridCoord(column, deletedRowIndex);
            this.boxes.remove((Object)coordinate);
        }
        if (oldRowCount == 1) {
            this.clear();
        } else {
            this.rowCount.set(oldRowCount - 1);
        }
    }

    public void deleteLastColumn() {
        int oldColumnCount = this.columnCount.get();
        if (oldColumnCount == 0) {
            return;
        }
        int deletedColumnIndex = oldColumnCount - 1;
        int currentRowCount = this.rowCount.get();
        for (int row = 0; row < currentRowCount; ++row) {
            GridCoord coordinate = new GridCoord(deletedColumnIndex, row);
            this.boxes.remove((Object)coordinate);
        }
        if (oldColumnCount == 1) {
            this.clear();
        } else {
            this.columnCount.set(oldColumnCount - 1);
        }
    }

    public void resizeTo(int desiredColumnCount, int desiredRowCount) {
        if (desiredColumnCount < 0 || desiredRowCount < 0) {
            throw new IllegalArgumentException("Invalid negative resize dimension: " + desiredColumnCount + "x" + desiredRowCount);
        }
        while (this.columnCount.get() < desiredColumnCount) {
            this.addColumn();
        }
        while (this.columnCount.get() > desiredColumnCount) {
            this.deleteLastColumn();
        }
        while (this.rowCount.get() < desiredRowCount) {
            this.addRow();
        }
        while (this.rowCount.get() > desiredRowCount) {
            this.deleteLastRow();
        }
    }

    public void clear() {
        this.boxes.clear();
        this.columnCount.set(0);
        this.rowCount.set(0);
    }

    private List<String> slotContentsOf(List<SlotOutline> slots) {
        ArrayList<String> contents = new ArrayList<String>();
        StringBuilder sb = new StringBuilder();
        for (SlotOutline slot : slots) {
            for (GridCoord pos : slot.boxPositions()) {
                CrosswordBoxViewModel box = (CrosswordBoxViewModel)this.boxes.get((Object)pos);
                String content = box.userContent().isEmpty() ? box.solverContent() : box.userContent();
                sb.append(content);
            }
            contents.add(sb.toString());
            sb.delete(0, sb.length());
        }
        return contents;
    }

    public void resetContentAll() {
        this.resetContent(box -> true);
    }

    public void resetContentLettersOnly() {
        this.resetContent(Predicate.not(CrosswordBoxViewModel::isShaded));
    }

    private void resetContent(Predicate<CrosswordBoxViewModel> predicate) {
        this.boxes.values().stream().filter(predicate).forEach(this::resetBox);
    }

    public void resetContentLettersFilledBySolverOnly() {
        this.boxes.values().forEach(box -> box.solverContent(""));
    }

    public void reset() {
        this.workingArea.currentBoxPosition.set(null);
        this.boxes.values().forEach(this::resetBox);
        this.resizeTo(6, 7);
    }

    private void resetBox(CrosswordBoxViewModel box) {
        box.userContent("");
        box.solverContent("");
        box.lighten();
        if (!box.isSelected()) {
            box.solvable();
        }
    }

    private final class WorkingArea {
        private final ObjectProperty<GridCoord> currentBoxPosition;
        private final ReadOnlyListWrapper<GridCoord> currentSlotPositions;
        private final ReadOnlyStringWrapper currentSlotContent;
        private final BooleanProperty currentSlotVertical;
        private final BooleanProperty currentSlotUnsolvable;
        final /* synthetic */ CrosswordGridViewModel this$0;

        WorkingArea(CrosswordGridViewModel crosswordGridViewModel) {
            CrosswordGridViewModel crosswordGridViewModel2 = crosswordGridViewModel;
            Objects.requireNonNull(crosswordGridViewModel2);
            this.this$0 = crosswordGridViewModel2;
            this.currentBoxPosition = new SimpleObjectProperty((Object)this, "currentBoxPosition");
            this.currentSlotPositions = new ReadOnlyListWrapper((Object)this, "currentSlotPositions", FXCollections.observableArrayList());
            this.currentSlotContent = new ReadOnlyStringWrapper((Object)this, "currentSlotContent", "");
            this.currentSlotVertical = new SimpleBooleanProperty((Object)this, "currentSlotVertical");
            this.currentSlotUnsolvable = new SimpleBooleanProperty((Object)this, "currentSlotUnsolvable");
            this.currentSlotPositions.addListener(this::onCurrentSlotPositionsChange);
            this.currentBoxPosition.addListener(this::onCurrentBoxChange);
            this.currentSlotVertical.addListener(observable -> this.recomputeCurrentSlotPositions());
            crosswordGridViewModel.columnCount.addListener(this::onDimensionChange);
            crosswordGridViewModel.rowCount.addListener(this::onDimensionChange);
            crosswordGridViewModel.boxes.forEach(this::onBoxAdded);
            crosswordGridViewModel.boxes.addListener(this::onGridChange);
            crosswordGridViewModel.slotsViewModel.acrossSlotsProperty().addListener(this::onHorizontalSlotsChange);
            crosswordGridViewModel.slotsViewModel.downSlotsProperty().addListener(this::onVerticalSlotsChange);
        }

        private void onGridChange(MapChangeListener.Change<? extends GridCoord, ? extends CrosswordBoxViewModel> change) {
            if (change.wasAdded()) {
                if (change.getValueRemoved() != null) {
                    throw new UnsupportedOperationException("Replacing box models is not supported");
                }
                this.onBoxAdded((GridCoord)change.getKey(), (CrosswordBoxViewModel)change.getValueAdded());
            }
        }

        private void onBoxAdded(GridCoord coordinate, CrosswordBoxViewModel box) {
            box.userContentProperty().addListener((InvalidationListener)new ContentChangeListener(this, coordinate));
        }

        private void onCurrentBoxChange(ObservableValue<? extends GridCoord> observable, GridCoord oldBoxPosition, GridCoord newBoxPosition) {
            if (!this.currentSlotPositions.contains((Object)newBoxPosition)) {
                this.recomputeCurrentSlotPositions();
            }
        }

        private void onDimensionChange(ObservableValue<? extends Number> observable, Number oldDimension, Number newDimension) {
            this.resetCurrentBoxPositionIfRemoved();
        }

        private void resetCurrentBoxPositionIfRemoved() {
            GridCoord current = (GridCoord)this.currentBoxPosition.get();
            if (current != null && !this.this$0.boxes.containsKey((Object)current)) {
                this.currentBoxPosition.set(null);
            }
        }

        private void onHorizontalSlotsChange(ListChangeListener.Change<? extends SlotOutline> change) {
            this.resetCurrentBoxPositionIfRemoved();
            GridCoord current = (GridCoord)this.currentBoxPosition.get();
            if (current == null || this.currentSlotVertical.get()) {
                return;
            }
            while (change.next()) {
                if (!Stream.concat(change.getAddedSubList().stream(), change.getRemoved().stream()).anyMatch(s -> s.contains(current))) continue;
                this.recomputeCurrentSlotPositions();
                break;
            }
        }

        private void onVerticalSlotsChange(ListChangeListener.Change<? extends SlotOutline> change) {
            this.resetCurrentBoxPositionIfRemoved();
            GridCoord current = (GridCoord)this.currentBoxPosition.get();
            if (current == null || !this.currentSlotVertical.get()) {
                return;
            }
            while (change.next()) {
                if (!Stream.concat(change.getAddedSubList().stream(), change.getRemoved().stream()).anyMatch(s -> s.contains(current))) continue;
                this.recomputeCurrentSlotPositions();
                break;
            }
        }

        private void recomputeCurrentSlotPositions() {
            if (this.currentBoxPosition.get() == null) {
                this.currentSlotPositions.clear();
            } else if (this.currentSlotVertical.get()) {
                this.recomputeVerticalCurrentSlotPositions();
            } else {
                this.recomputeCurrentHorizontalSlotPositions();
            }
        }

        private void recomputeCurrentHorizontalSlotPositions() {
            GridCoord current = (GridCoord)this.currentBoxPosition.get();
            this.this$0.slotsViewModel.acrossSlotContaining(current).map(SlotOutline::boxPositions).ifPresentOrElse(arg_0 -> this.currentSlotPositions.setAll(arg_0), () -> this.currentSlotPositions.clear());
        }

        private void recomputeVerticalCurrentSlotPositions() {
            GridCoord current = (GridCoord)this.currentBoxPosition.get();
            this.this$0.slotsViewModel.downSlotContaining(current).map(SlotOutline::boxPositions).ifPresentOrElse(arg_0 -> this.currentSlotPositions.setAll(arg_0), () -> this.currentSlotPositions.clear());
        }

        private void recomputeCurrentSlotContent() {
            StringBuilder contentBuilder = new StringBuilder(this.currentSlotPositions.size());
            for (GridCoord position : this.currentSlotPositions) {
                String letter = ((CrosswordBoxViewModel)this.this$0.boxes.get((Object)position)).userContent();
                contentBuilder.append(letter.isEmpty() ? "." : letter);
            }
            this.currentSlotContent.set(contentBuilder.toString());
        }

        private void onCurrentSlotPositionsChange(ListChangeListener.Change<? extends GridCoord> change) {
            while (change.next()) {
                change.getRemoved().stream().map(arg_0 -> this.this$0.boxes.get(arg_0)).filter(Objects::nonNull).forEach(box -> {
                    box.deselect();
                    box.unsolvableProperty().unbind();
                    box.solvable();
                });
                change.getAddedSubList().stream().map(arg_0 -> this.this$0.boxes.get(arg_0)).forEach(box -> {
                    box.select();
                    box.unsolvableProperty().bind((ObservableValue)this.currentSlotUnsolvable);
                });
                this.recomputeCurrentSlotContent();
            }
        }

        private final class ContentChangeListener
        implements InvalidationListener {
            private final GridCoord listenedBoxCoordinate;
            final /* synthetic */ WorkingArea this$1;

            ContentChangeListener(WorkingArea workingArea, GridCoord listenedBoxCoordinateArg) {
                WorkingArea workingArea2 = workingArea;
                Objects.requireNonNull(workingArea2);
                this.this$1 = workingArea2;
                this.listenedBoxCoordinate = listenedBoxCoordinateArg;
            }

            public void invalidated(Observable observable) {
                if (!this.this$1.this$0.inhibitContentChangeEvents && this.this$1.currentSlotPositions.contains((Object)this.listenedBoxCoordinate)) {
                    this.this$1.recomputeCurrentSlotContent();
                }
            }
        }
    }
}

