/*
 * Decompiled with CFR 0.152.
 */
package re.belv.croiseur.gui.view.model;

import java.util.List;
import java.util.stream.IntStream;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ListProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import re.belv.croiseur.gui.view.model.ClueViewModel;
import re.belv.croiseur.gui.view.model.CluesViewModel;
import re.belv.croiseur.gui.view.model.CrosswordGridViewModel;
import re.belv.croiseur.gui.view.model.GridCoord;
import re.belv.croiseur.gui.view.model.PuzzleDetailsViewModel;
import re.belv.croiseur.gui.view.model.slot.SlotOutline;

public final class PuzzleEditionViewModel {
    private final PuzzleDetailsViewModel puzzleDetailsViewModel = new PuzzleDetailsViewModel();
    private final CrosswordGridViewModel crosswordGridViewModel = CrosswordGridViewModel.welcomeGrid();
    private final CluesViewModel cluesViewModel = new CluesViewModel();
    private final BooleanProperty savingInProgress = new SimpleBooleanProperty((Object)this, "savingInProgress");

    PuzzleEditionViewModel() {
        ObservableList<SlotOutline> acrossSlots = this.crosswordGridViewModel.longAcrossSlots();
        ListProperty<ClueViewModel> acrossClues = this.cluesViewModel.acrossCluesProperty();
        acrossSlots.forEach(slot -> acrossClues.add(new ClueViewModel()));
        acrossSlots.addListener(this::updateAcrossClues);
        this.cluesViewModel.selectedAcrossClueIndexProperty().addListener(observable -> this.updateCurrentAcrossSlot(this.cluesViewModel.selectedAcrossClueIndex()));
        ObservableList<SlotOutline> downSlots = this.crosswordGridViewModel.longDownSlots();
        ListProperty<ClueViewModel> downClues = this.cluesViewModel.downCluesProperty();
        downSlots.forEach(slot -> downClues.add(new ClueViewModel()));
        downSlots.addListener(this::updateDownClues);
        this.cluesViewModel.selectedDownClueIndexProperty().addListener(observable -> this.updateCurrentDownSlot(this.cluesViewModel.selectedDownClueIndex()));
        this.crosswordGridViewModel.currentSlotPositionsProperty().addListener(observable -> this.updateCurrentClue(this.crosswordGridViewModel.currentSlotPositions()));
    }

    public PuzzleDetailsViewModel puzzleDetailsViewModel() {
        return this.puzzleDetailsViewModel;
    }

    public CrosswordGridViewModel crosswordGridViewModel() {
        return this.crosswordGridViewModel;
    }

    public CluesViewModel cluesViewModel() {
        return this.cluesViewModel;
    }

    public BooleanProperty savingInProgressProperty() {
        return this.savingInProgress;
    }

    public void reset() {
        this.puzzleDetailsViewModel.reset();
        this.crosswordGridViewModel.reset();
        this.cluesViewModel.reset();
    }

    private void updateAcrossClues(ListChangeListener.Change<? extends SlotOutline> c) {
        while (c.next()) {
            ListProperty<ClueViewModel> acrossClues = this.cluesViewModel.acrossCluesProperty();
            if (c.wasReplaced()) {
                IntStream.range(c.getFrom(), c.getTo()).forEach(i -> ((ClueViewModel)acrossClues.get(i)).reset());
                continue;
            }
            if (c.wasRemoved()) {
                acrossClues.remove(c.getFrom(), c.getFrom() + c.getRemovedSize());
                continue;
            }
            if (!c.wasAdded()) continue;
            List<ClueViewModel> newClues = c.getAddedSubList().stream().map(slot -> new ClueViewModel()).toList();
            acrossClues.addAll(c.getFrom(), newClues);
        }
    }

    private void updateDownClues(ListChangeListener.Change<? extends SlotOutline> c) {
        while (c.next()) {
            ListProperty<ClueViewModel> downClues = this.cluesViewModel.downCluesProperty();
            if (c.wasReplaced()) {
                IntStream.range(c.getFrom(), c.getTo()).forEach(i -> ((ClueViewModel)downClues.get(i)).reset());
                continue;
            }
            if (c.wasRemoved()) {
                downClues.remove(c.getFrom(), c.getFrom() + c.getRemovedSize());
                continue;
            }
            if (!c.wasAdded()) continue;
            List<ClueViewModel> newClues = c.getAddedSubList().stream().map(slot -> new ClueViewModel()).toList();
            downClues.addAll(c.getFrom(), newClues);
        }
    }

    private void updateCurrentDownSlot(int selectedDownClueIndex) {
        if (selectedDownClueIndex >= 0) {
            List<GridCoord> slotPositions = ((SlotOutline)this.crosswordGridViewModel.longDownSlots().get(selectedDownClueIndex)).boxPositions();
            this.crosswordGridViewModel.currentSlotVertical();
            if (!slotPositions.contains(this.crosswordGridViewModel.currentBoxPosition())) {
                this.crosswordGridViewModel.currentBoxPosition(slotPositions.get(0));
            }
        }
    }

    private void updateCurrentAcrossSlot(int selectedAcrossClueIndex) {
        if (selectedAcrossClueIndex >= 0) {
            List<GridCoord> slotPositions = ((SlotOutline)this.crosswordGridViewModel.longAcrossSlots().get(selectedAcrossClueIndex)).boxPositions();
            this.crosswordGridViewModel.currentSlotHorizontal();
            if (!slotPositions.contains(this.crosswordGridViewModel.currentBoxPosition())) {
                this.crosswordGridViewModel.currentBoxPosition(slotPositions.get(0));
            }
        }
    }

    private void updateCurrentClue(List<GridCoord> currentSlotPositions) {
        if (currentSlotPositions.isEmpty()) {
            this.cluesViewModel.deselectAcrossClue();
            this.cluesViewModel.deselectDownClue();
        } else if (this.crosswordGridViewModel.currentSlotVerticalProperty().get()) {
            this.crosswordGridViewModel.indexOfLongDownSlotContaining(currentSlotPositions.get(0)).ifPresentOrElse(this.cluesViewModel::selectedDownClueIndex, this.cluesViewModel::deselectDownClue);
        } else {
            this.crosswordGridViewModel.indexOfLongAcrossSlotContaining(currentSlotPositions.get(0)).ifPresentOrElse(this.cluesViewModel::selectedAcrossClueIndex, this.cluesViewModel::deselectAcrossClue);
        }
    }
}

