/*
 * Decompiled with CFR 0.152.
 */
package re.belv.croiseur.gui.view.model.slot;

import java.util.List;
import java.util.ListIterator;
import java.util.Optional;
import re.belv.croiseur.gui.view.model.GridCoord;
import re.belv.croiseur.gui.view.model.slot.AcrossSlotsLightenedBoxProcessor;
import re.belv.croiseur.gui.view.model.slot.DownSlotsLightenedBoxProcessor;
import re.belv.croiseur.gui.view.model.slot.SlotOutline;

abstract sealed class LightenedBoxProcessor
permits AcrossSlotsLightenedBoxProcessor, DownSlotsLightenedBoxProcessor {
    private final List<SlotOutline> slots;

    protected LightenedBoxProcessor(List<SlotOutline> slotsArg) {
        this.slots = slotsArg;
    }

    final void process(GridCoord lightenedBoxCoordinates) {
        int lightenedBoxOffset = this.offsetCoordinateOf(lightenedBoxCoordinates);
        int lightenedBoxIndex = this.varyingCoordinateOf(lightenedBoxCoordinates);
        Optional<SlotOutline> firstHalfOpt = this.slots.stream().filter(slot -> slot.offset == lightenedBoxOffset && slot.end == lightenedBoxIndex).findFirst();
        Optional<SlotOutline> secondHalfOpt = this.slots.stream().filter(slot -> slot.offset == lightenedBoxOffset && slot.start == lightenedBoxIndex + 1).findFirst();
        if (firstHalfOpt.isPresent()) {
            SlotOutline updatedFirstHalf;
            SlotOutline firstHalf = firstHalfOpt.get();
            if (secondHalfOpt.isPresent()) {
                SlotOutline secondHalf = secondHalfOpt.get();
                updatedFirstHalf = this.slotOf(firstHalf.start, secondHalf.end, lightenedBoxOffset);
                this.slots.remove(secondHalf);
            } else {
                updatedFirstHalf = this.slotOf(firstHalf.start, lightenedBoxIndex + 1, lightenedBoxOffset);
            }
            int firstHalfIndex = this.slots.indexOf(firstHalf);
            this.slots.set(firstHalfIndex, updatedFirstHalf);
        } else if (secondHalfOpt.isPresent()) {
            SlotOutline secondHalf = secondHalfOpt.get();
            SlotOutline updatedSecondHalf = this.slotOf(lightenedBoxIndex, secondHalf.end, lightenedBoxOffset);
            int secondHalfIndex = this.slots.indexOf(secondHalf);
            this.slots.set(secondHalfIndex, updatedSecondHalf);
        } else {
            SlotOutline newSlot = this.slotOf(lightenedBoxIndex, lightenedBoxIndex + 1, lightenedBoxOffset);
            int insertionIndex = this.insertionIndexFor(newSlot);
            this.slots.add(insertionIndex, newSlot);
        }
    }

    private int insertionIndexFor(SlotOutline newSlot) {
        int insertionIndex = 0;
        ListIterator<SlotOutline> it = this.slots.listIterator();
        while (it.hasNext()) {
            SlotOutline slot = it.next();
            if (slot.offset >= newSlot.offset && (slot.offset != newSlot.offset || slot.end >= newSlot.start)) break;
            insertionIndex = it.nextIndex();
        }
        return insertionIndex;
    }

    abstract SlotOutline slotOf(int var1, int var2, int var3);

    abstract int offsetCoordinateOf(GridCoord var1);

    abstract int varyingCoordinateOf(GridCoord var1);
}

