/*
 * Decompiled with CFR 0.152.
 */
package re.belv.croiseur.gui.view.model.slot;

import java.util.List;
import re.belv.croiseur.gui.view.model.GridCoord;
import re.belv.croiseur.gui.view.model.slot.AcrossSlotShadedBoxProcessor;
import re.belv.croiseur.gui.view.model.slot.DownSlotShadedBoxProcessor;
import re.belv.croiseur.gui.view.model.slot.SlotOutline;

abstract sealed class ShadedBoxProcessor
permits AcrossSlotShadedBoxProcessor, DownSlotShadedBoxProcessor {
    private final List<SlotOutline> slots;

    ShadedBoxProcessor(List<SlotOutline> slotsArg) {
        this.slots = slotsArg;
    }

    final void process(GridCoord shadedBoxCoordinates) {
        SlotOutline slot = this.slots.stream().filter(s -> s.contains(shadedBoxCoordinates)).findFirst().orElseThrow();
        int slotIndex = this.slots.indexOf(slot);
        int shadedBoxIndex = this.varyingCoordinateOf(shadedBoxCoordinates);
        if (shadedBoxIndex > slot.start) {
            SlotOutline firstHalf = this.slotOf(slot.start, shadedBoxIndex, slot.offset);
            this.slots.set(slotIndex, firstHalf);
            if (slot.end > shadedBoxIndex + 1) {
                SlotOutline secondHalf = this.slotOf(shadedBoxIndex + 1, slot.end, slot.offset);
                this.slots.add(slotIndex + 1, secondHalf);
            }
        } else if (slot.end > shadedBoxIndex + 1) {
            SlotOutline secondHalf = this.slotOf(shadedBoxIndex + 1, slot.end, slot.offset);
            this.slots.set(slotIndex, secondHalf);
        } else {
            this.slots.remove(slotIndex);
        }
    }

    abstract SlotOutline slotOf(int var1, int var2, int var3);

    abstract int varyingCoordinateOf(GridCoord var1);
}

