/*
 * Decompiled with CFR 0.152.
 */
package re.belv.croiseur.dictionary.xml.plugin;

import java.io.File;
import java.io.FileInputStream;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import re.belv.croiseur.common.dictionary.DictionaryDetails;
import re.belv.croiseur.dictionary.common.StringFilters;
import re.belv.croiseur.dictionary.common.StringTransformers;
import re.belv.croiseur.dictionary.common.util.Lazy;
import re.belv.croiseur.dictionary.xml.codec.DictionaryHeader;
import re.belv.croiseur.dictionary.xml.codec.DictionaryReadException;
import re.belv.croiseur.dictionary.xml.codec.DictionaryReader;
import re.belv.croiseur.spi.dictionary.Dictionary;

final class XmlDictionary
implements Dictionary {
    private static final Logger LOGGER = Logger.getLogger(XmlDictionary.class.getName());
    private final Lazy<DictionaryDetails> details;
    private final Lazy<Set<String>> words;

    XmlDictionary(File file) {
        DictionaryReader reader = new DictionaryReader(() -> new FileInputStream(file));
        this.details = Lazy.of(() -> XmlDictionary.readDetails(reader));
        this.words = Lazy.of(() -> XmlDictionary.readWords(reader));
    }

    private static String extractName(DictionaryHeader header) {
        Map names = header.names();
        return Objects.requireNonNullElseGet((String)names.get(Locale.getDefault()), () -> (String)names.get(Locale.ENGLISH));
    }

    private static String extractDescription(DictionaryHeader header) {
        Map descriptions = header.descriptions();
        return Objects.requireNonNullElseGet((String)descriptions.get(Locale.getDefault()), () -> (String)descriptions.get(Locale.ENGLISH));
    }

    private static DictionaryDetails readDetails(DictionaryReader reader) {
        try {
            DictionaryHeader header = reader.readHeader();
            String name = XmlDictionary.extractName(header);
            Locale locale = header.locale();
            String description = XmlDictionary.extractDescription(header);
            return new DictionaryDetails(name, locale, description);
        }
        catch (DictionaryReadException e) {
            LOGGER.log(Level.WARNING, e, () -> "Failed to read dictionary details");
            return DictionaryDetails.unknown();
        }
    }

    private static Set<String> readWords(DictionaryReader reader) {
        try {
            return reader.readWords().filter(StringFilters.notEmpty()).map(StringTransformers.toAcceptableCrosswordEntry()).collect(Collectors.toCollection(LinkedHashSet::new));
        }
        catch (DictionaryReadException e) {
            LOGGER.log(Level.WARNING, e, () -> "Failed to read dictionary words");
            return Collections.emptySet();
        }
    }

    public DictionaryDetails details() {
        return (DictionaryDetails)this.details.get();
    }

    public Set<String> words() {
        return (Set)this.words.get();
    }
}

