/*
 * Decompiled with CFR 0.152.
 */
package re.belv.croiseur.dictionary.hunspell.plugin;

import java.net.URL;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.stream.Collectors;
import re.belv.croiseur.common.dictionary.DictionaryDetails;
import re.belv.croiseur.dictionary.common.StringFilters;
import re.belv.croiseur.dictionary.common.StringTransformers;
import re.belv.croiseur.dictionary.common.util.Lazy;
import re.belv.croiseur.dictionary.hunspell.codec.HunspellDictionaryReader;
import re.belv.croiseur.spi.dictionary.Dictionary;

final class HunspellDictionary
implements Dictionary {
    private final Lazy<DictionaryDetails> details;
    private final Lazy<Set<String>> words;

    public HunspellDictionary(URL aDicURL) {
        HunspellDictionaryReader dictionary = new HunspellDictionaryReader(aDicURL);
        this.details = Lazy.of(() -> ((HunspellDictionaryReader)dictionary).details());
        this.words = Lazy.of(() -> dictionary.stream().filter(StringFilters.notEmpty()).map(StringTransformers.toAcceptableCrosswordEntry()).collect(Collectors.toCollection(LinkedHashSet::new)));
    }

    public DictionaryDetails details() {
        return (DictionaryDetails)this.details.get();
    }

    public Set<String> words() {
        return Collections.unmodifiableSet((Set)this.words.get());
    }
}

