/*
 * Decompiled with CFR 0.152.
 */
package re.belv.croiseur.puzzle.codec.xd.plugin;

import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Stream;
import re.belv.croiseur.common.puzzle.GridPosition;
import re.belv.croiseur.common.puzzle.Puzzle;
import re.belv.croiseur.common.puzzle.PuzzleClues;
import re.belv.croiseur.common.puzzle.PuzzleDetails;
import re.belv.croiseur.common.puzzle.PuzzleGrid;
import re.belv.croiseur.puzzle.codec.xd.model.XdClue;
import re.belv.croiseur.puzzle.codec.xd.model.XdClues;
import re.belv.croiseur.puzzle.codec.xd.model.XdCrossword;
import re.belv.croiseur.puzzle.codec.xd.model.XdGrid;
import re.belv.croiseur.puzzle.codec.xd.model.XdMetadata;
import re.belv.croiseur.spi.puzzle.codec.PuzzleDecodingException;

final class PuzzleConverter {
    private PuzzleConverter() {
    }

    static Puzzle toDomain(XdCrossword xdModel) throws PuzzleDecodingException {
        PuzzleDetails details = PuzzleConverter.toDomain(xdModel.metadata());
        PuzzleGrid grid = PuzzleConverter.toDomain(xdModel.grid());
        PuzzleClues clues = PuzzleConverter.toDomain(xdModel.clues());
        return new Puzzle(details, grid, clues);
    }

    private static PuzzleDetails toDomain(XdMetadata persistenceMetadataModel) {
        return new PuzzleDetails(persistenceMetadataModel.title().orElse(""), persistenceMetadataModel.author().orElse(""), persistenceMetadataModel.editor().orElse(""), persistenceMetadataModel.copyright().orElse(""), persistenceMetadataModel.date());
    }

    private static PuzzleGrid toDomain(XdGrid persistenceGridModel) throws PuzzleDecodingException {
        if (!persistenceGridModel.spaces().isEmpty()) {
            throw new PuzzleDecodingException("Cannot convert grid with spaces: This is not supported by Croiseur.");
        }
        PuzzleGrid.Builder builder = new PuzzleGrid.Builder();
        persistenceGridModel.blocks().stream().map(PuzzleConverter::toDomain).forEach(arg_0 -> ((PuzzleGrid.Builder)builder).shade(arg_0));
        persistenceGridModel.filled().forEach((index, letter) -> builder.fill(PuzzleConverter.toDomain(index), Character.valueOf(letter.charAt(0))));
        return builder.width(PuzzleConverter.width(persistenceGridModel)).height(PuzzleConverter.height(persistenceGridModel)).build();
    }

    private static PuzzleClues toDomain(XdClues persistenceCluesModel) {
        List<String> acrossClues = persistenceCluesModel.acrossClues().stream().map(XdClue::clue).toList();
        List<String> downClues = persistenceCluesModel.downClues().stream().map(XdClue::clue).toList();
        return new PuzzleClues(acrossClues, downClues);
    }

    private static GridPosition toDomain(XdGrid.Index persistenceGridPosition) {
        return new GridPosition(persistenceGridPosition.column(), persistenceGridPosition.row());
    }

    private static int width(XdGrid persistenceGridModel) throws PuzzleDecodingException {
        return PuzzleConverter.maxDimension(persistenceGridModel, XdGrid.Index::column);
    }

    private static int height(XdGrid persistenceGridModel) throws PuzzleDecodingException {
        return PuzzleConverter.maxDimension(persistenceGridModel, XdGrid.Index::row);
    }

    private static int maxDimension(XdGrid persistedGrid, Function<XdGrid.Index, Integer> dimension) throws PuzzleDecodingException {
        return 1 + Stream.of(persistedGrid.blocks(), persistedGrid.filled().keySet(), persistedGrid.nonFilled()).flatMap(Collection::stream).map(dimension).max(Comparator.naturalOrder()).orElseThrow(() -> new PuzzleDecodingException("Invalid empty grid"));
    }

    static XdCrossword toXd(Puzzle domainModel) {
        XdMetadata metadata = PuzzleConverter.toXd(domainModel.details());
        XdGrid grid = PuzzleConverter.toXd(domainModel.grid());
        XdClues clues = PuzzleConverter.toXd(domainModel.grid(), domainModel.clues());
        return new XdCrossword(metadata, grid, clues);
    }

    static XdMetadata toXd(PuzzleDetails details) {
        XdMetadata.Builder builder = new XdMetadata.Builder();
        if (!details.title().isEmpty()) {
            builder.title(details.title());
        }
        if (!details.author().isEmpty()) {
            builder.author(details.author());
        }
        if (!details.editor().isEmpty()) {
            builder.editor(details.editor());
        }
        if (!details.copyright().isEmpty()) {
            builder.copyright(details.copyright());
        }
        details.date().ifPresent(arg_0 -> ((XdMetadata.Builder)builder).date(arg_0));
        return builder.build();
    }

    static XdGrid toXd(PuzzleGrid grid) {
        XdGrid.Builder builder = new XdGrid.Builder();
        for (int row = 0; row < grid.height(); ++row) {
            for (int column = 0; column < grid.width(); ++column) {
                Character letter = (Character)grid.filled().get(GridPosition.at((int)column, (int)row));
                if (letter != null) {
                    builder.filled(XdGrid.Index.at((int)column, (int)row), letter.charValue());
                    continue;
                }
                if (grid.shaded().contains(GridPosition.at((int)column, (int)row))) {
                    builder.block(XdGrid.Index.at((int)column, (int)row));
                    continue;
                }
                builder.nonFilled(XdGrid.Index.at((int)column, (int)row));
            }
        }
        return builder.build();
    }

    private static XdClues toXd(PuzzleGrid grid, PuzzleClues clues) {
        XdClues.Builder builder = new XdClues.Builder();
        List acrossSlotsContents = grid.acrossSlotContents();
        List acrossClues = clues.across();
        for (int i = 0; i < acrossClues.size(); ++i) {
            builder.across(i + 1, (String)acrossClues.get(i), (String)acrossSlotsContents.get(i));
        }
        List downSlotContents = grid.downSlotContents();
        List downClues = clues.down();
        for (int i = 0; i < downClues.size(); ++i) {
            builder.down(i + 1, (String)downClues.get(i), (String)downSlotContents.get(i));
        }
        return builder.build();
    }
}

