/*
 * Decompiled with CFR 0.152.
 */
package re.belv.croiseur.api;

import java.util.Collection;
import java.util.ServiceLoader;
import java.util.function.Supplier;
import re.belv.croiseur.api.clue.ClueService;
import re.belv.croiseur.api.dictionary.DictionaryService;
import re.belv.croiseur.api.puzzle.PuzzleService;
import re.belv.croiseur.api.solver.SolverService;
import re.belv.croiseur.impl.CrosswordServiceImpl;
import re.belv.croiseur.spi.clue.ClueProvider;
import re.belv.croiseur.spi.dictionary.DictionaryProvider;
import re.belv.croiseur.spi.presenter.Presenter;
import re.belv.croiseur.spi.puzzle.codec.PuzzleDecoder;
import re.belv.croiseur.spi.puzzle.codec.PuzzleEncoder;
import re.belv.croiseur.spi.puzzle.repository.DummyPuzzleRepository;
import re.belv.croiseur.spi.puzzle.repository.PuzzleRepository;
import re.belv.croiseur.spi.solver.CrosswordSolver;

public interface CrosswordService {
    public static CrosswordService create(Collection<DictionaryProvider> dictionaryProviders, Collection<CrosswordSolver> solvers, Collection<ClueProvider> clueProviders, Collection<PuzzleDecoder> puzzleDecoders, Collection<PuzzleEncoder> puzzleEncoders, PuzzleRepository puzzleRepository, Presenter presenter) {
        return new CrosswordServiceImpl(dictionaryProviders, solvers, clueProviders, puzzleDecoders, puzzleEncoders, puzzleRepository, presenter);
    }

    public static CrosswordService create() {
        Collection<DictionaryProvider> dictionaryProviders = CrosswordService.load(DictionaryProvider.class);
        Collection<CrosswordSolver> solvers = CrosswordService.load(CrosswordSolver.class);
        Collection<ClueProvider> clueProviders = CrosswordService.load(ClueProvider.class);
        Collection<PuzzleDecoder> puzzleDecoders = CrosswordService.load(PuzzleDecoder.class);
        Collection<PuzzleEncoder> puzzleEncoders = CrosswordService.load(PuzzleEncoder.class);
        PuzzleRepository puzzleRepository = CrosswordService.load(PuzzleRepository.class).stream().findFirst().orElseGet(DummyPuzzleRepository::new);
        Collection<Presenter> presenters = CrosswordService.load(Presenter.class);
        if (presenters.isEmpty()) {
            throw new IllegalStateException("Failed to instantiate crossword service: No presenter found");
        }
        return CrosswordService.create(dictionaryProviders, solvers, clueProviders, puzzleDecoders, puzzleEncoders, puzzleRepository, Presenter.broadcastingTo(presenters));
    }

    private static <T> Collection<T> load(Class<T> clazz) {
        return ServiceLoader.load(clazz).stream().map(Supplier::get).toList();
    }

    public DictionaryService dictionaryService();

    public SolverService solverService();

    public ClueService clueService();

    public PuzzleService puzzleService();
}

