/*
 * Decompiled with CFR 0.152.
 */
package re.belv.croiseur.impl.clue;

import java.util.Collection;
import java.util.Map;
import re.belv.croiseur.api.clue.GetClueRequest;
import re.belv.croiseur.impl.clue.shared.SafeClueProvider;
import re.belv.croiseur.spi.clue.ClueProvider;
import re.belv.croiseur.spi.presenter.clue.CluePresenter;

final class GetClueUsecase {
    private final SafeClueProvider clueRetriever;
    private final CluePresenter cluePresenter;

    GetClueUsecase(Collection<ClueProvider> clueProvidersArg, CluePresenter cluePresenterArg) {
        this.clueRetriever = new SafeClueProvider(clueProvidersArg, cluePresenterArg);
        this.cluePresenter = cluePresenterArg;
    }

    void process(GetClueRequest event) {
        Map<String, String> clues = this.clueRetriever.getClues(event.clueProvider().orElse(null), event.words());
        if (!clues.isEmpty()) {
            this.cluePresenter.presentClues(clues);
        }
    }
}

