/*
 * Decompiled with CFR 0.152.
 */
package re.belv.croiseur.impl.clue.shared;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import re.belv.croiseur.spi.clue.ClueProvider;
import re.belv.croiseur.spi.presenter.clue.CluePresenter;

public final class SafeClueProvider {
    private final Collection<ClueProvider> clueProviders;
    private final CluePresenter cluePresenter;

    public SafeClueProvider(Collection<ClueProvider> clueProvidersArg, CluePresenter cluePresenterArg) {
        this.clueProviders = clueProvidersArg;
        this.cluePresenter = cluePresenterArg;
    }

    public Map<String, String> getClues(Set<String> words) {
        return this.getClues(null, words);
    }

    public Map<String, String> getClues(String providerName, Set<String> words) {
        Optional<ClueProvider> selectedClueProvider = this.selectClueProvider(providerName);
        if (selectedClueProvider.isEmpty()) {
            this.cluePresenter.presentClueError("No clue provider found");
            return Collections.emptyMap();
        }
        Map<String, String> clues = this.safeGetClues(selectedClueProvider.get(), words);
        if (clues.isEmpty()) {
            this.cluePresenter.presentClueError("Couldn't find any acceptable clues");
        }
        return clues;
    }

    private Optional<ClueProvider> selectClueProvider(String providerName) {
        return this.clueProviders.stream().filter(clueProvider -> providerName == null || clueProvider.name().equals(providerName)).findFirst();
    }

    private Map<String, String> safeGetClues(ClueProvider clueProvider, Set<String> words) {
        try {
            return clueProvider.define(words);
        }
        catch (Exception e) {
            String error = String.format("Clue provider %s failed with the following message: %s", clueProvider.name(), e.getMessage());
            this.cluePresenter.presentClueError(error);
            return Collections.emptyMap();
        }
    }
}

