/*
 * Decompiled with CFR 0.152.
 */
package re.belv.croiseur.impl.dictionary;

import java.util.Collection;
import java.util.List;
import java.util.stream.Stream;
import re.belv.croiseur.api.dictionary.ListDictionariesRequest;
import re.belv.croiseur.common.dictionary.ProvidedDictionaryDetails;
import re.belv.croiseur.impl.dictionary.selection.DictionaryComparator;
import re.belv.croiseur.impl.dictionary.selection.DictionaryProviderFilter;
import re.belv.croiseur.spi.dictionary.DictionaryProvider;
import re.belv.croiseur.spi.presenter.dictionary.DictionaryPresenter;

final class ListDictionariesUsecase {
    private final Collection<DictionaryProvider> dictionaryProviders;
    private final DictionaryPresenter presenter;

    ListDictionariesUsecase(Collection<DictionaryProvider> dictionaryProvidersArg, DictionaryPresenter presenterArg) {
        this.dictionaryProviders = dictionaryProvidersArg;
        this.presenter = presenterArg;
    }

    private static Stream<ProvidedDictionaryDetails> toDictionaryDetailsStream(DictionaryProvider provider) {
        return provider.get().stream().map(dictionary -> new ProvidedDictionaryDetails(provider.details().name(), dictionary.details()));
    }

    private static List<ProvidedDictionaryDetails> orderDictionaries(Collection<DictionaryProvider> selectedDictionaryProviders) {
        return selectedDictionaryProviders.stream().flatMap(ListDictionariesUsecase::toDictionaryDetailsStream).sorted(new DictionaryComparator()).toList();
    }

    void process(ListDictionariesRequest request) {
        Collection<DictionaryProvider> selectedDictionaryProviders = this.selectDictionaryProviders(request);
        if (selectedDictionaryProviders.isEmpty()) {
            this.presenter.presentDictionaryError("No dictionary found");
        } else {
            List<ProvidedDictionaryDetails> dictionaries = ListDictionariesUsecase.orderDictionaries(selectedDictionaryProviders);
            this.presenter.presentDictionaries(dictionaries);
        }
    }

    private Collection<DictionaryProvider> selectDictionaryProviders(ListDictionariesRequest request) {
        return DictionaryProviderFilter.byOptionalProvider(request.provider()).and(DictionaryProviderFilter.byOptionalLocale(request.locale())).apply(this.dictionaryProviders);
    }
}

