/*
 * Decompiled with CFR 0.152.
 */
package re.belv.croiseur.impl.dictionary;

import java.util.List;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import re.belv.croiseur.api.dictionary.SearchDictionaryEntriesRequest;
import re.belv.croiseur.common.util.Either;
import re.belv.croiseur.impl.dictionary.selection.DictionarySelector;
import re.belv.croiseur.impl.dictionary.selection.SelectedDictionary;
import re.belv.croiseur.spi.presenter.dictionary.DictionaryPresenter;
import re.belv.croiseur.spi.presenter.dictionary.DictionarySearchResult;

final class SearchDictionaryEntriesUsecase {
    private final DictionarySelector dictionarySelector;
    private final DictionaryPresenter presenter;

    SearchDictionaryEntriesUsecase(DictionarySelector dictionarySelectorArg, DictionaryPresenter dictionaryPresenterArg) {
        this.dictionarySelector = dictionarySelectorArg;
        this.presenter = dictionaryPresenterArg;
    }

    void process(SearchDictionaryEntriesRequest request) {
        Either<String, SelectedDictionary> dictionarySelection = this.dictionarySelector.select(request.dictionaryIdentifier());
        if (dictionarySelection.isLeft()) {
            this.presenter.presentDictionaryError((String)dictionarySelection.left());
        } else {
            SelectedDictionary selectedDictionary = (SelectedDictionary)dictionarySelection.right();
            Predicate<String> regex = Pattern.compile(request.searchExpression()).asMatchPredicate();
            List<String> foundWords = selectedDictionary.words().stream().filter(regex).toList();
            DictionarySearchResult searchResult = new DictionarySearchResult(foundWords);
            this.presenter.presentDictionarySearchResult(searchResult);
        }
    }
}

