/*
 * Decompiled with CFR 0.152.
 */
package re.belv.croiseur.impl.puzzle;

import java.util.Collection;
import re.belv.croiseur.api.puzzle.PuzzleService;
import re.belv.croiseur.api.puzzle.exporter.PuzzleExportService;
import re.belv.croiseur.api.puzzle.importer.PuzzleImportService;
import re.belv.croiseur.api.puzzle.persistence.PuzzlePersistenceService;
import re.belv.croiseur.impl.puzzle.exporter.PuzzleExportServiceImpl;
import re.belv.croiseur.impl.puzzle.importer.PuzzleImportServiceImpl;
import re.belv.croiseur.impl.puzzle.persistence.PuzzlePersistenceServiceImpl;
import re.belv.croiseur.impl.puzzle.persistence.shared.SafePuzzleRepository;
import re.belv.croiseur.spi.presenter.puzzle.PuzzlePresenter;
import re.belv.croiseur.spi.puzzle.codec.PuzzleDecoder;
import re.belv.croiseur.spi.puzzle.codec.PuzzleEncoder;
import re.belv.croiseur.spi.puzzle.repository.PuzzleRepository;

public final class PuzzleServiceImpl
implements PuzzleService {
    private final PuzzlePersistenceService persistence;
    private final PuzzleImportService importer;
    private final PuzzleExportService exporter;

    public PuzzleServiceImpl(PuzzleRepository repositoryArg, Collection<PuzzleDecoder> decoders, Collection<PuzzleEncoder> encoders, PuzzlePresenter presenter) {
        SafePuzzleRepository repository = new SafePuzzleRepository(repositoryArg, presenter);
        this.persistence = new PuzzlePersistenceServiceImpl(repository, presenter);
        this.importer = new PuzzleImportServiceImpl(repository, decoders, presenter);
        this.exporter = new PuzzleExportServiceImpl(repository, encoders, presenter);
    }

    @Override
    public PuzzlePersistenceService persistence() {
        return this.persistence;
    }

    @Override
    public PuzzleImportService importer() {
        return this.importer;
    }

    @Override
    public PuzzleExportService exporter() {
        return this.exporter;
    }
}

