/*
 * Decompiled with CFR 0.152.
 */
package re.belv.croiseur.impl.puzzle.exporter;

import java.io.OutputStream;
import java.util.Collection;
import re.belv.croiseur.api.puzzle.exporter.PuzzleExportService;
import re.belv.croiseur.impl.puzzle.exporter.ExportPuzzleUsecase;
import re.belv.croiseur.impl.puzzle.exporter.ListPuzzleEncodersUsecase;
import re.belv.croiseur.impl.puzzle.persistence.shared.SafePuzzleRepository;
import re.belv.croiseur.spi.presenter.puzzle.PuzzlePresenter;
import re.belv.croiseur.spi.puzzle.codec.PuzzleEncoder;

public final class PuzzleExportServiceImpl
implements PuzzleExportService {
    private final ListPuzzleEncodersUsecase listPuzzleEncodersUsecase;
    private final ExportPuzzleUsecase exportPuzzleUsecase;

    public PuzzleExportServiceImpl(SafePuzzleRepository repository, Collection<PuzzleEncoder> encoders, PuzzlePresenter presenter) {
        this.listPuzzleEncodersUsecase = new ListPuzzleEncodersUsecase(encoders, presenter);
        this.exportPuzzleUsecase = new ExportPuzzleUsecase(repository, encoders, presenter);
    }

    @Override
    public void listEncoders() {
        this.listPuzzleEncodersUsecase.process();
    }

    @Override
    public void exportPuzzle(long id, String format, OutputStream outputStream) {
        this.exportPuzzleUsecase.process(id, format, outputStream);
    }
}

