/*
 * Decompiled with CFR 0.152.
 */
package re.belv.croiseur.impl.puzzle.persistence.shared;

import java.util.Collection;
import java.util.Optional;
import re.belv.croiseur.common.puzzle.ChangedPuzzle;
import re.belv.croiseur.common.puzzle.Puzzle;
import re.belv.croiseur.common.puzzle.SavedPuzzle;
import re.belv.croiseur.spi.presenter.puzzle.PuzzlePresenter;
import re.belv.croiseur.spi.puzzle.repository.PuzzleRepository;
import re.belv.croiseur.spi.puzzle.repository.WriteException;

public final class SafePuzzleRepository {
    private final PuzzleRepository repository;
    private final PuzzlePresenter presenter;

    public SafePuzzleRepository(PuzzleRepository repositoryArg, PuzzlePresenter presenterArg) {
        this.repository = repositoryArg;
        this.presenter = presenterArg;
    }

    public Optional<SavedPuzzle> create(Puzzle puzzle) {
        try {
            SavedPuzzle savedPuzzle = this.repository.create(puzzle);
            this.presenter.presentSavedPuzzle(savedPuzzle);
            return Optional.of(savedPuzzle);
        }
        catch (WriteException e) {
            this.presenter.presentPuzzleRepositoryError("Failed to create puzzle: " + e.getMessage());
            return Optional.empty();
        }
    }

    public Optional<SavedPuzzle> update(ChangedPuzzle changedPuzzle) {
        try {
            SavedPuzzle savedPuzzle = this.repository.update(changedPuzzle);
            this.presenter.presentSavedPuzzle(savedPuzzle);
            return Optional.of(savedPuzzle);
        }
        catch (WriteException e) {
            this.presenter.presentPuzzleRepositoryError("Failed to update puzzle: " + e.getMessage());
            return Optional.empty();
        }
    }

    public Optional<SavedPuzzle> query(long id) {
        return this.repository.query(id);
    }

    public void delete(long id) {
        try {
            this.repository.delete(id);
            this.presenter.presentDeletedPuzzle(id);
        }
        catch (WriteException e) {
            this.presenter.presentPuzzleRepositoryError("Failed to delete puzzle: " + e.getMessage());
        }
    }

    public void deleteAll() {
        try {
            this.repository.deleteAll();
            this.presenter.presentDeletedAllPuzzles();
        }
        catch (WriteException e) {
            this.presenter.presentPuzzleRepositoryError("Failed to delete puzzle(s): " + e.getMessage());
        }
    }

    public Collection<SavedPuzzle> list() {
        return this.repository.list();
    }
}

