/*
 * Decompiled with CFR 0.152.
 */
package re.belv.croiseur.impl.solver;

import java.util.Collection;
import re.belv.croiseur.api.solver.SolveRequest;
import re.belv.croiseur.api.solver.SolverService;
import re.belv.croiseur.impl.solver.ListSolversUsecase;
import re.belv.croiseur.impl.solver.SolveUsecase;
import re.belv.croiseur.spi.clue.ClueProvider;
import re.belv.croiseur.spi.dictionary.DictionaryProvider;
import re.belv.croiseur.spi.presenter.Presenter;
import re.belv.croiseur.spi.presenter.solver.SolverPresenter;
import re.belv.croiseur.spi.puzzle.repository.PuzzleRepository;
import re.belv.croiseur.spi.solver.CrosswordSolver;

public final class SolverServiceImpl
implements SolverService {
    private final ListSolversUsecase listSolversUsecase;
    private final SolveUsecase solveUsecase;

    public SolverServiceImpl(Collection<CrosswordSolver> solvers, Collection<DictionaryProvider> dictionaryProviders, Collection<ClueProvider> clueProviders, PuzzleRepository puzzleRepository, Presenter presenter) {
        this.listSolversUsecase = new ListSolversUsecase(solvers, (SolverPresenter)presenter);
        this.solveUsecase = new SolveUsecase(solvers, dictionaryProviders, clueProviders, puzzleRepository, presenter);
    }

    @Override
    public void listSolvers() {
        this.listSolversUsecase.process();
    }

    @Override
    public void solve(SolveRequest event) {
        this.solveUsecase.process(event);
    }
}

