/*
 * Decompiled with CFR 0.152.
 */
package re.belv.croiseur.clue.openai.plugin;

import com.azure.ai.openai.OpenAIClient;
import com.azure.ai.openai.OpenAIClientBuilder;
import com.azure.ai.openai.models.ChatChoice;
import com.azure.ai.openai.models.ChatCompletionsOptions;
import com.azure.ai.openai.models.ChatRequestMessage;
import com.azure.ai.openai.models.ChatRequestSystemMessage;
import com.azure.ai.openai.models.ChatRequestUserMessage;
import com.azure.core.credential.KeyCredential;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import re.belv.croiseur.clue.openai.plugin.ModelConfiguration;

final class ClueGenerator {
    private static final String OPENAI_API_KEY = "OPENAI_API_KEY";
    private final OpenAIClient openAiService;
    private final ModelConfiguration config;
    private final String systemMessage;
    private final String userMessageHeader;
    private final String placeholder;

    public ClueGenerator() {
        String token = System.getenv(OPENAI_API_KEY);
        this.openAiService = new OpenAIClientBuilder().credential(new KeyCredential(token)).buildClient();
        this.config = new ModelConfiguration();
        ResourceBundle rb = ResourceBundle.getBundle("re.belv.croiseur.clue.openai.plugin.Prompt");
        this.systemMessage = rb.getString("system");
        this.userMessageHeader = rb.getString("user");
        this.placeholder = rb.getString("placeholder");
    }

    private static Map<String, String> extractClues(List<String> words, List<ChatChoice> completion) {
        if (completion.isEmpty()) {
            return Collections.emptyMap();
        }
        String[] payload = completion.getFirst().getMessage().getContent().split("\\R");
        if (payload.length != words.size()) {
            return Collections.emptyMap();
        }
        HashMap<String, String> clues = new HashMap<String, String>();
        for (int i = 0; i < words.size(); ++i) {
            String word = words.get(i);
            String clue = payload[i].trim().replace("\"", "").replaceFirst("^" + word + "\\s*(:\\s*)?", "");
            clues.put(word, clue);
        }
        return clues;
    }

    public Map<String, String> generate(Set<String> words) {
        ArrayList<String> orderedWords = new ArrayList<String>(words);
        ChatCompletionsOptions completionRequest = this.createRequest(orderedWords);
        List choices = this.openAiService.getChatCompletions(this.config.model(), completionRequest).getChoices();
        return ClueGenerator.extractClues(orderedWords, choices);
    }

    private ChatCompletionsOptions createRequest(List<String> words) {
        List<ChatRequestMessage> prompt = this.createPrompt(words);
        return new ChatCompletionsOptions(prompt).setModel(this.config.model()).setFrequencyPenalty(Double.valueOf(this.config.frequencyPenalty())).setTemperature(Double.valueOf(this.config.temperature()));
    }

    private List<ChatRequestMessage> createPrompt(List<String> words) {
        ChatRequestSystemMessage system = new ChatRequestSystemMessage(this.systemMessage);
        ChatRequestUserMessage userHeader = new ChatRequestUserMessage(this.userMessageHeader);
        StringBuilder userMessageBodyBuilder = new StringBuilder();
        for (String word : words) {
            userMessageBodyBuilder.append(word).append(':').append(this.placeholder);
            userMessageBodyBuilder.append(System.lineSeparator());
        }
        ChatRequestUserMessage userBody = new ChatRequestUserMessage(userMessageBodyBuilder.toString());
        return List.of(system, userHeader, userBody);
    }
}

