/*
 * Decompiled with CFR 0.152.
 */
package re.belv.croiseur.clue.openai.plugin;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import re.belv.croiseur.clue.openai.plugin.ModelConfigurationException;

final class ModelConfiguration {
    private final Properties properties = new Properties();

    ModelConfiguration() {
        try (InputStream is = ModelConfiguration.class.getResourceAsStream("config.properties");){
            if (is == null) {
                throw new ModelConfigurationException("Missing plugin configuration");
            }
            this.properties.load(is);
            if (!this.properties.containsKey("model")) {
                throw new ModelConfigurationException("Incomplete plugin configuration: Field 'model' is mandatory");
            }
        }
        catch (IOException e) {
            throw new ModelConfigurationException("Failed to read plugin configuration", e);
        }
    }

    String model() {
        return this.properties.getProperty("model");
    }

    double frequencyPenalty() {
        return this.doubleProperty("frequency_penalty", 0.0);
    }

    double temperature() {
        return this.doubleProperty("temperature", 1.0);
    }

    private double doubleProperty(String key, double defaultValue) {
        String stringValue = this.properties.getProperty(key);
        return stringValue != null ? Double.parseDouble(stringValue) : defaultValue;
    }
}

