/*
 * Decompiled with CFR 0.152.
 */
package re.belv.croiseur.common.puzzle;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import re.belv.croiseur.common.puzzle.GridPosition;

public record PuzzleGrid(int width, int height, Set<GridPosition> shaded, Map<GridPosition, Character> filled) {
    private final Set<GridPosition> shaded;
    private final Map<GridPosition, Character> filled;
    private static final int MIN_SLOT_LENGTH = 2;

    public PuzzleGrid {
        if (width <= 0 || height <= 0) {
            throw new IllegalArgumentException("Invalid grid dimensions");
        }
        Objects.requireNonNull(shaded);
        shaded.forEach(PuzzleGrid.validateCoordinates(width, height));
        Objects.requireNonNull(filled);
        filled.keySet().forEach(PuzzleGrid.validateCoordinates(width, height));
        filled.values().forEach(Objects::requireNonNull);
    }

    private static Consumer<GridPosition> validateCoordinates(int width, int height) {
        return coordinate -> {
            if (coordinate.x() >= width || coordinate.y() >= height) {
                throw new IllegalArgumentException("Coordinates outside " + width + "x" + height + " grid: " + String.valueOf(coordinate));
            }
        };
    }

    public Set<GridPosition> shaded() {
        return Collections.unmodifiableSet(this.shaded);
    }

    public Map<GridPosition, Character> filled() {
        return Collections.unmodifiableMap(this.filled);
    }

    public List<String> acrossSlotContents() {
        ArrayList<String> slotContents = new ArrayList<String>();
        StringBuilder contentBuffer = new StringBuilder();
        for (int row = 0; row < this.height; ++row) {
            int columnStart;
            for (int column = columnStart = 0; column < this.width; ++column) {
                GridPosition position = GridPosition.at(column, row);
                if (this.shaded.contains(position)) {
                    if (column - columnStart >= 2) {
                        slotContents.add(contentBuffer.toString());
                    }
                    columnStart = column + 1;
                    contentBuffer.delete(0, contentBuffer.length());
                    continue;
                }
                contentBuffer.append(this.filled.getOrDefault(position, Character.valueOf('.')));
            }
            if (this.width - columnStart >= 2) {
                slotContents.add(contentBuffer.toString());
            }
            contentBuffer.delete(0, contentBuffer.length());
        }
        return slotContents;
    }

    public List<String> downSlotContents() {
        ArrayList<String> slotContents = new ArrayList<String>();
        StringBuilder contentBuffer = new StringBuilder();
        for (int column = 0; column < this.width; ++column) {
            int rowStart;
            for (int row = rowStart = 0; row < this.height; ++row) {
                GridPosition position = GridPosition.at(column, row);
                if (this.shaded.contains(position)) {
                    if (row - rowStart >= 2) {
                        slotContents.add(contentBuffer.toString());
                    }
                    rowStart = row + 1;
                    contentBuffer.delete(0, contentBuffer.length());
                    continue;
                }
                contentBuffer.append(this.filled.getOrDefault(position, Character.valueOf('.')));
            }
            if (this.height - rowStart >= 2) {
                slotContents.add(contentBuffer.toString());
            }
            contentBuffer.delete(0, contentBuffer.length());
        }
        return slotContents;
    }

    public Set<String> slotContents() {
        HashSet<String> slots = new HashSet<String>(this.acrossSlotContents());
        slots.addAll(this.downSlotContents());
        return slots;
    }

    public static final class Builder {
        private final Set<GridPosition> shaded = new HashSet<GridPosition>();
        private final Map<GridPosition, Character> filled = new HashMap<GridPosition, Character>();
        private int width;
        private int height;

        public Builder shade(GridPosition position) {
            this.filled.remove(position);
            this.shaded.add(position);
            return this;
        }

        public Builder fill(GridPosition position, Character character) {
            this.shaded.remove(position);
            this.filled.put(position, character);
            return this;
        }

        public Builder width(int widthArg) {
            this.width = widthArg;
            return this;
        }

        public Builder height(int heightArg) {
            this.height = heightArg;
            return this;
        }

        public PuzzleGrid build() {
            return new PuzzleGrid(this.width, this.height, this.shaded, this.filled);
        }
    }
}

