/*
 * Decompiled with CFR 0.152.
 */
package re.belv.croiseur.common.puzzle;

import java.util.Objects;
import re.belv.croiseur.common.puzzle.ChangedPuzzle;
import re.belv.croiseur.common.puzzle.Puzzle;
import re.belv.croiseur.common.puzzle.PuzzleClues;
import re.belv.croiseur.common.puzzle.PuzzleDetails;
import re.belv.croiseur.common.puzzle.PuzzleGrid;

public record SavedPuzzle(long id, Puzzle data, int revision) {
    public SavedPuzzle {
        Objects.requireNonNull(data);
    }

    public ChangedPuzzle modifiedWith(Puzzle newData) {
        Objects.requireNonNull(newData);
        return new ChangedPuzzle(this.id, newData);
    }

    public ChangedPuzzle modifiedWith(PuzzleGrid newGrid) {
        Puzzle newData = new Puzzle(this.details(), newGrid, this.clues());
        return this.modifiedWith(newData);
    }

    public ChangedPuzzle modifiedWith(PuzzleGrid newGrid, PuzzleClues newClues) {
        Puzzle newData = new Puzzle(this.details(), newGrid, newClues);
        return this.modifiedWith(newData);
    }

    public ChangedPuzzle modifiedWith(PuzzleDetails newDetails) {
        Puzzle newData = new Puzzle(newDetails, this.grid(), this.clues());
        return this.modifiedWith(newData);
    }

    public ChangedPuzzle asChangedPuzzle() {
        return new ChangedPuzzle(this.id, this.data);
    }

    public PuzzleGrid grid() {
        return this.data.grid();
    }

    public PuzzleDetails details() {
        return this.data.details();
    }

    public PuzzleClues clues() {
        return this.data.clues();
    }
}

