/*
 * Decompiled with CFR 0.152.
 */
package re.belv.croiseur.dictionary.hunspell.codec;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import re.belv.croiseur.common.dictionary.DictionaryDetails;
import re.belv.croiseur.dictionary.common.SegmentableUrl;
import re.belv.croiseur.dictionary.common.io.BomInputStream;
import re.belv.croiseur.dictionary.hunspell.codec.model.aff.Aff;
import re.belv.croiseur.dictionary.hunspell.codec.model.dic.Dic;
import re.belv.croiseur.dictionary.hunspell.codec.parser.aff.AffParser;
import re.belv.croiseur.dictionary.hunspell.codec.parser.common.ParserException;
import re.belv.croiseur.dictionary.hunspell.codec.parser.dic.DicParser;
import re.belv.croiseur.dictionary.hunspell.codec.wordforms.WordFormGenerator;

public final class HunspellDictionaryReader {
    private static final Logger LOGGER = Logger.getLogger(HunspellDictionaryReader.class.getName());
    private static final String DIC_EXTENSION = ".dic";
    private static final String AFF_EXTENSION = ".aff";
    private final URL dicURL;

    public HunspellDictionaryReader(URL aDicURL) {
        this.dicURL = Objects.requireNonNull(aDicURL);
    }

    private static Stream<String> streamer(URL url) throws IOException {
        return HunspellDictionaryReader.streamer(url, StandardCharsets.US_ASCII);
    }

    private static Stream<String> streamer(URL url, Charset charset) throws IOException {
        return new BufferedReader(new InputStreamReader((InputStream)new BomInputStream(url.openStream()), charset)).lines();
    }

    public DictionaryDetails details() {
        return new DictionaryDetails(this.name(), this.locale(), this.description());
    }

    public Stream<String> stream() {
        return this.readEntries();
    }

    private Locale locale() {
        String languageTag = this.languageTag();
        return Locale.forLanguageTag(languageTag);
    }

    private String name() {
        return "Hunspell Dictionary " + new SegmentableUrl(this.dicURL).lastPathSegment();
    }

    private String description() {
        return "Hunspell Dictionary for " + this.locale().getDisplayName();
    }

    private Stream<String> readEntries() {
        Optional<Aff> optAff = this.readAff();
        if (optAff.isEmpty()) {
            return Stream.empty();
        }
        Optional<Dic> optDic = this.readDic(optAff.get());
        if (optDic.isEmpty()) {
            return Stream.empty();
        }
        return WordFormGenerator.of(optAff.get(), optDic.get()).generate();
    }

    private Optional<Aff> readAff() {
        Optional<Aff> optional;
        block17: {
            Charset encoding;
            Stream<String> lines;
            URL affUrl = this.affUrl();
            try {
                lines = HunspellDictionaryReader.streamer(affUrl);
                try {
                    encoding = AffParser.identifyEncoding(lines.iterator());
                }
                finally {
                    if (lines != null) {
                        lines.close();
                    }
                }
            }
            catch (IOException e) {
                LOGGER.log(Level.WARNING, "Failed to read aff file at " + String.valueOf(affUrl), e);
                return Optional.empty();
            }
            LOGGER.fine(() -> "Detected encoding " + String.valueOf(encoding));
            lines = HunspellDictionaryReader.streamer(affUrl, encoding);
            try {
                Aff aff = new AffParser().parse(lines.iterator());
                optional = Optional.of(aff);
                if (lines == null) break block17;
            }
            catch (Throwable throwable) {
                try {
                    if (lines != null) {
                        try {
                            lines.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException | ParserException e) {
                    LOGGER.log(Level.WARNING, "Failed to read aff file at " + String.valueOf(affUrl), e);
                    return Optional.empty();
                }
            }
            lines.close();
        }
        return optional;
    }

    private Optional<Dic> readDic(Aff aff) {
        Optional<Dic> optional;
        block8: {
            Stream<String> lines = HunspellDictionaryReader.streamer(this.dicURL, aff.encoding());
            try {
                Dic dic = new DicParser(aff.flagType()).parse(lines.iterator());
                optional = Optional.of(dic);
                if (lines == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (lines != null) {
                        try {
                            lines.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException | ParserException e) {
                    LOGGER.log(Level.WARNING, "Failed to read dic file at " + String.valueOf(this.dicURL), e);
                    return Optional.empty();
                }
            }
            lines.close();
        }
        return optional;
    }

    private URL affUrl() {
        try {
            String affUrlExternalForm = Pattern.compile(".dic$").matcher(this.dicURL.toExternalForm()).replaceFirst(AFF_EXTENSION);
            return new URL(affUrlExternalForm);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private String languageTag() {
        String dicFileName = new SegmentableUrl(this.dicURL).lastPathSegment();
        return dicFileName.replace(DIC_EXTENSION, "").replace("_", "-");
    }
}

