/*
 * Decompiled with CFR 0.152.
 */
package re.belv.croiseur.dictionary.hunspell.codec.parser.aff;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.Map;
import java.util.function.BiConsumer;
import re.belv.croiseur.dictionary.hunspell.codec.model.aff.Aff;
import re.belv.croiseur.dictionary.hunspell.codec.parser.aff.AffBuilder;
import re.belv.croiseur.dictionary.hunspell.codec.parser.aff.AffItemKind;
import re.belv.croiseur.dictionary.hunspell.codec.parser.aff.AffixClassHeaderParser;
import re.belv.croiseur.dictionary.hunspell.codec.parser.aff.AffixRuleParser;
import re.belv.croiseur.dictionary.hunspell.codec.parser.aff.CompoundFlagParser;
import re.belv.croiseur.dictionary.hunspell.codec.parser.aff.EncodingParser;
import re.belv.croiseur.dictionary.hunspell.codec.parser.aff.FlagTypeParser;
import re.belv.croiseur.dictionary.hunspell.codec.parser.aff.UnknownAffItemException;
import re.belv.croiseur.dictionary.hunspell.codec.parser.common.ParserException;

public final class AffParser {
    private static final Map<AffItemKind, Parser> PARSERS = new EnumMap<AffItemKind, Parser>(AffItemKind.class);
    private static final int ENCODING_OPTION_SEARCH_LIMIT = 50;

    private static Parser parser(AffItemKind affItemKind) {
        return PARSERS.computeIfAbsent(affItemKind, kind -> Parser.DUMMY);
    }

    public static Charset identifyEncoding(Iterator<String> lines) {
        for (int i = 1; i <= 50; ++i) {
            String line = lines.next();
            if (!AffItemKind.identify(line).filter(AffItemKind.GENERAL_ENCODING::equals).isPresent()) continue;
            return EncodingParser.parse(line);
        }
        return StandardCharsets.US_ASCII;
    }

    public Aff parse(Iterator<String> lines) throws ParserException {
        AffBuilder modelBuilder = new AffBuilder();
        while (lines.hasNext()) {
            String line = lines.next();
            AffItemKind kind = AffItemKind.identify(line).orElseThrow(() -> new UnknownAffItemException(line));
            AffParser.parser(kind).parse(modelBuilder, line);
        }
        return modelBuilder.build();
    }

    static {
        PARSERS.put(AffItemKind.AFFIX_HEADER, (builder, line) -> builder.addAffixClassHeader(AffixClassHeaderParser.parse(line)));
        PARSERS.put(AffItemKind.AFFIX_RULE, (builder, line) -> builder.addAffixRule(AffixRuleParser.parse(line, builder.flagType())));
        PARSERS.put(AffItemKind.COMPOUNDING_COMPOUNDFLAG, (builder, line) -> builder.setCompoundFlag(CompoundFlagParser.COMPOUNDFLAG.parse((String)line)));
        PARSERS.put(AffItemKind.COMPOUNDING_COMPOUNDBEGIN, (builder, line) -> builder.setCompoundBeginFlag(CompoundFlagParser.COMPOUNDBEGIN.parse((String)line)));
        PARSERS.put(AffItemKind.COMPOUNDING_COMPOUNDMIDDLE, (builder, line) -> builder.setCompoundMiddleFlag(CompoundFlagParser.COMPOUNDMIDDLE.parse((String)line)));
        PARSERS.put(AffItemKind.COMPOUNDING_COMPOUNDEND, (builder, line) -> builder.setCompoundEndFlag(CompoundFlagParser.COMPOUNDEND.parse((String)line)));
        PARSERS.put(AffItemKind.GENERAL_ENCODING, (builder, line) -> builder.setEncoding(EncodingParser.parse(line)));
        PARSERS.put(AffItemKind.GENERAL_FLAG_TYPE, (builder, line) -> builder.setFlagType(FlagTypeParser.parse(line)));
    }

    private static interface Parser
    extends BiConsumer<AffBuilder, String> {
        public static final Parser DUMMY = (model, event) -> {};

        default public void parse(AffBuilder model, String event) {
            this.accept(model, event);
        }
    }
}

