/*
 * Decompiled with CFR 0.152.
 */
package re.belv.croiseur.dictionary.hunspell.codec.parser.aff;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import re.belv.croiseur.dictionary.hunspell.codec.model.common.Flag;

enum CompoundFlagParser {
    COMPOUNDFLAG("FLAG"),
    COMPOUNDBEGIN("BEGIN"),
    COMPOUNDMIDDLE("MIDDLE"),
    COMPOUNDEND("END");

    private final Pattern pattern;

    private CompoundFlagParser(String nameSuffix) {
        this.pattern = Pattern.compile("^COMPOUND" + nameSuffix + " +(?<identifier>[^ ])+$");
    }

    Flag parse(String line) {
        Matcher matcher = this.pattern.matcher(line);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Not a compound flag: " + line);
        }
        String identifier = matcher.group("identifier");
        return new Flag(identifier);
    }
}

