/*
 * Decompiled with CFR 0.152.
 */
package re.belv.croiseur.dictionary.hunspell.codec.parser.aff;

import java.util.EnumMap;
import java.util.Map;
import java.util.regex.Pattern;
import re.belv.croiseur.dictionary.hunspell.codec.parser.common.FlagType;

final class FlagTypeParser {
    private static final Map<FlagType, Pattern> PATTERNS = new EnumMap<FlagType, Pattern>(FlagType.class);

    private FlagTypeParser() {
    }

    static FlagType parse(String line) {
        return PATTERNS.entrySet().stream().filter(entry -> ((Pattern)entry.getValue()).matcher(line).matches()).findFirst().map(Map.Entry::getKey).orElseThrow(IllegalArgumentException::new);
    }

    static {
        PATTERNS.put(FlagType.LONG_ASCII, Pattern.compile("^FLAG long$"));
        PATTERNS.put(FlagType.NUMERICAL, Pattern.compile("^FLAG num$"));
        PATTERNS.put(FlagType.UTF_8, Pattern.compile("^FLAG UTF-8$"));
    }
}

