/*
 * Decompiled with CFR 0.152.
 */
package re.belv.croiseur.dictionary.hunspell.codec.parser.aff;

import java.util.Objects;
import java.util.Optional;
import re.belv.croiseur.dictionary.hunspell.codec.model.aff.ThreePartsCompoundFlags;
import re.belv.croiseur.dictionary.hunspell.codec.model.common.Flag;

final class ThreePartsCompoundFlagsBuilder {
    private Flag begin;
    private Flag middle;
    private Flag end;

    ThreePartsCompoundFlagsBuilder() {
    }

    ThreePartsCompoundFlagsBuilder setBeginFlag(Flag beginArg) {
        if (this.begin != null) {
            throw new IllegalStateException("Illegal attempt to set COMPOUNDBEGIN value a second time");
        }
        this.begin = Objects.requireNonNull(beginArg);
        return this;
    }

    ThreePartsCompoundFlagsBuilder setMiddleFlag(Flag middleArg) {
        if (this.middle != null) {
            throw new IllegalStateException("Illegal attempt to set COMPOUNDMIDDLE value a second time");
        }
        this.middle = Objects.requireNonNull(middleArg);
        return this;
    }

    ThreePartsCompoundFlagsBuilder setEndFlag(Flag endArg) {
        if (this.end != null) {
            throw new IllegalStateException("Illegal attempt to set COMPOUNDEND value a second time");
        }
        this.end = Objects.requireNonNull(endArg);
        return this;
    }

    Optional<ThreePartsCompoundFlags> build() {
        if (this.begin == null) {
            if (this.middle != null) {
                throw new IllegalArgumentException("COMPOUNDBEGIN not set but COMPOUNDMIDDLE is");
            }
            if (this.end != null) {
                throw new IllegalArgumentException("COMPOUNDBEGIN not set but not COMPOUNDEND is");
            }
            return Optional.empty();
        }
        return Optional.of(new ThreePartsCompoundFlags(this.begin, this.middle, this.end));
    }
}

