/*
 * Decompiled with CFR 0.152.
 */
package re.belv.croiseur.dictionary.hunspell.codec.wordforms;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Stream;
import re.belv.croiseur.dictionary.hunspell.codec.model.aff.AffixClass;
import re.belv.croiseur.dictionary.hunspell.codec.model.common.Flag;
import re.belv.croiseur.dictionary.hunspell.codec.model.dic.DicEntry;
import re.belv.croiseur.dictionary.hunspell.codec.wordforms.AffixClassApplicator;
import re.belv.croiseur.dictionary.hunspell.codec.wordforms.AffixClasses;
import re.belv.croiseur.dictionary.hunspell.codec.wordforms.BeginEndCompound;
import re.belv.croiseur.dictionary.hunspell.codec.wordforms.BeginMiddleEndCompound;

final class Affixer
implements Function<DicEntry, Stream<String>> {
    private final AffixClasses affixClasses;
    private final Map<Flag, AffixClassApplicator> affixClassApplicators;

    Affixer(AffixClasses affixClassesArg) {
        this.affixClasses = affixClassesArg;
        this.affixClassApplicators = new HashMap<Flag, AffixClassApplicator>();
        for (AffixClass affixClass : this.affixClasses) {
            this.affixClassApplicators.put(affixClass.flag(), new AffixClassApplicator(affixClass, this.affixClasses));
        }
    }

    @Override
    public Stream<String> apply(DicEntry entry) {
        return this.affixClasses.referencedBy(entry.flags()).map(cls -> this.affixClassApplicators.get(cls.flag())).flatMap(affixClassApplicator -> affixClassApplicator.apply(entry));
    }

    @Override
    Stream<String> apply(BeginEndCompound compound) {
        String compoundedForm = compound.word();
        DicEntry prefixablePseudoDicEntry = new DicEntry(false, compoundedForm, compound.endFlags());
        Stream prefixed = this.affixClasses.referencedBy(compound.beginFlags()).filter(cls -> cls.kind().isPrefix()).map(cls -> this.affixClassApplicators.get(cls.flag())).flatMap(affixClassApplicator -> affixClassApplicator.apply(prefixablePseudoDicEntry));
        DicEntry suffixablePseudoDicEntry = new DicEntry(false, compoundedForm, compound.beginFlags());
        Stream suffixed = this.affixClasses.referencedBy(compound.endFlags()).filter(cls -> cls.kind().isSuffix()).map(cls -> this.affixClassApplicators.get(cls.flag())).flatMap(affixClassApplicator -> affixClassApplicator.apply(suffixablePseudoDicEntry));
        return Stream.concat(prefixed, suffixed);
    }

    @Override
    Stream<String> apply(BeginMiddleEndCompound compound) {
        String compoundedForm = compound.word();
        DicEntry prefixablePseudoDicEntry = new DicEntry(false, compoundedForm, compound.endFlags());
        Stream prefixed = this.affixClasses.referencedBy(compound.beginFlags()).filter(cls -> cls.kind().isPrefix()).map(cls -> this.affixClassApplicators.get(cls.flag())).flatMap(affixClassApplicator -> affixClassApplicator.apply(prefixablePseudoDicEntry));
        DicEntry suffixablePseudoDicEntry = new DicEntry(false, compoundedForm, compound.beginFlags());
        Stream suffixed = this.affixClasses.referencedBy(compound.endFlags()).filter(cls -> cls.kind().isSuffix()).map(cls -> this.affixClassApplicators.get(cls.flag())).flatMap(affixClassApplicator -> affixClassApplicator.apply(suffixablePseudoDicEntry));
        return Stream.concat(prefixed, suffixed);
    }
}

