/*
 * Decompiled with CFR 0.152.
 */
package re.belv.croiseur.gui;

import java.io.File;
import java.util.List;
import java.util.ResourceBundle;
import java.util.concurrent.Executor;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.binding.When;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.Property;
import javafx.beans.property.ReadOnlyListProperty;
import javafx.beans.property.ReadOnlyMapProperty;
import javafx.beans.property.ReadOnlyStringProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.ListChangeListener;
import javafx.fxml.FXML;
import javafx.stage.FileChooser;
import re.belv.croiseur.api.CrosswordService;
import re.belv.croiseur.gui.SceneSwitcher;
import re.belv.croiseur.gui.controller.clue.ClueController;
import re.belv.croiseur.gui.controller.dictionary.DictionaryController;
import re.belv.croiseur.gui.controller.puzzle.PuzzleController;
import re.belv.croiseur.gui.controller.solver.SolverController;
import re.belv.croiseur.gui.view.CrosswordEditorPane;
import re.belv.croiseur.gui.view.model.ApplicationViewModel;
import re.belv.croiseur.gui.view.model.CluesViewModel;
import re.belv.croiseur.gui.view.model.CrosswordGridViewModel;
import re.belv.croiseur.gui.view.model.DictionariesViewModel;
import re.belv.croiseur.gui.view.model.DictionaryViewModel;
import re.belv.croiseur.gui.view.model.PuzzleCodecsViewModel;
import re.belv.croiseur.gui.view.model.PuzzleDetailsViewModel;
import re.belv.croiseur.gui.view.model.SolverConfigurationViewModel;
import re.belv.croiseur.gui.view.model.SolverProgressViewModel;

final class CrosswordEditorController {
    private final DictionaryController dictionaryController;
    private final SolverController solverController;
    private final PuzzleController puzzleController;
    private final ClueController clueController;
    private final ApplicationViewModel applicationViewModel;
    private final FileChooser fileChooser;
    private final SceneSwitcher sceneSwitcher;
    @FXML
    private CrosswordEditorPane view;
    @FXML
    private ResourceBundle resources;

    CrosswordEditorController(CrosswordService crosswordService, ApplicationViewModel applicationViewModelArg, SceneSwitcher sceneSwitcherArg, Executor executor) {
        this.dictionaryController = new DictionaryController(crosswordService.dictionaryService(), executor);
        this.solverController = new SolverController(applicationViewModelArg, crosswordService.solverService(), executor);
        this.clueController = new ClueController(applicationViewModelArg.cluesViewModel(), applicationViewModelArg.crosswordGridViewModel(), crosswordService.clueService(), executor);
        this.puzzleController = new PuzzleController(applicationViewModelArg.puzzleSelectionViewModel(), applicationViewModelArg.puzzleEditionViewModel(), crosswordService.puzzleService(), executor);
        this.applicationViewModel = applicationViewModelArg;
        this.fileChooser = new FileChooser();
        this.sceneSwitcher = sceneSwitcherArg;
    }

    @FXML
    private void initialize() {
        this.initializeCrosswordGridBindings();
        this.initializeDictionaryBindings();
        this.initializeSolverConfigurationBindings();
        this.initializeSolverProgressBindings();
        this.initializeOtherSolverBindings();
        this.initializePuzzleBindings();
        this.initializePuzzleExportBindings();
        this.initializeNavigationBindings();
        this.initializeClueBindings();
        this.populateModels();
    }

    private void initializePuzzleBindings() {
        PuzzleDetailsViewModel viewModel = this.applicationViewModel.puzzleDetailsViewModel();
        this.view.puzzleTitleProperty().bindBidirectional((Property)viewModel.titleProperty());
        this.view.puzzleAuthorProperty().bindBidirectional((Property)viewModel.authorProperty());
        this.view.puzzleEditorProperty().bindBidirectional((Property)viewModel.editorProperty());
        this.view.puzzleCopyrightProperty().bindBidirectional((Property)viewModel.copyrightProperty());
        this.view.puzzleDateProperty().bindBidirectional((Property)viewModel.dateProperty());
        this.view.onSaveButtonActionProperty().set(e -> this.puzzleController.savePuzzle());
        BooleanProperty puzzleIsBeingSaved = this.applicationViewModel.puzzleIsBeingSaved();
        this.view.puzzleEditionDisableProperty().bind((ObservableValue)puzzleIsBeingSaved);
    }

    private void initializePuzzleExportBindings() {
        this.fileChooser.setTitle(this.resources.getString("export-filechooser-title"));
        PuzzleCodecsViewModel puzzleCodecsViewModel = this.applicationViewModel.puzzleCodecsViewModel();
        puzzleCodecsViewModel.encodersProperty().addListener(observable -> {
            List<FileChooser.ExtensionFilter> extensionFilters = puzzleCodecsViewModel.encodersProperty().stream().map(codec -> new FileChooser.ExtensionFilter(codec.name(), codec.extensions())).toList();
            this.fileChooser.getExtensionFilters().setAll(extensionFilters);
        });
        this.view.onExportPuzzleButtonActionProperty().set(e -> this.onExportButtonAction());
        PuzzleDetailsViewModel puzzleDetailsViewModel = this.applicationViewModel.puzzleDetailsViewModel();
        BooleanBinding puzzleNotSavedYet = Bindings.createBooleanBinding(() -> puzzleDetailsViewModel.id() == null, (Observable[])new Observable[]{puzzleDetailsViewModel.idProperty()});
        this.view.puzzleExportButtonDisableProperty().bind((ObservableValue)puzzleNotSavedYet);
    }

    private void onExportButtonAction() {
        File selectedFile = this.fileChooser.showSaveDialog(this.view.getScene().getWindow());
        if (selectedFile != null) {
            List selectedExtensions = this.fileChooser.getSelectedExtensionFilter().getExtensions();
            String selectedFormat = selectedExtensions.isEmpty() ? "unknown" : (String)selectedExtensions.get(0);
            this.puzzleController.exportPuzzle(selectedFile, selectedFormat);
        }
    }

    private void initializeCrosswordGridBindings() {
        CrosswordGridViewModel viewModel = this.applicationViewModel.crosswordGridViewModel();
        this.view.gridBoxesProperty().set((Object)viewModel.boxesProperty());
        this.view.gridCurrentBoxProperty().bindBidirectional((Property)viewModel.currentBoxPositionProperty());
        this.view.gridCurrentSlotOrientationVerticalProperty().bindBidirectional((Property)viewModel.currentSlotVerticalProperty());
        this.view.onAddRowActionButtonProperty().set(event -> viewModel.addRow());
        this.view.onAddColumnActionButtonProperty().set(event -> viewModel.addColumn());
        this.view.onDeleteColumnActionButtonProperty().set(event -> viewModel.deleteLastColumn());
        this.view.onDeleteRowActionButtonProperty().set(event -> viewModel.deleteLastRow());
        this.view.onClearGridAllLettersMenuItemActionProperty().set(event -> viewModel.resetContentLettersOnly());
        this.view.onClearGridLettersFilledBySolverMenuItemActionProperty().set(event -> viewModel.resetContentLettersFilledBySolverOnly());
        this.view.onClearGridContentMenuItemActionProperty().set(event -> viewModel.resetContentAll());
        this.view.onDeleteGridActionProperty().set(event -> viewModel.clear());
        BooleanBinding editionAllowed = this.applicationViewModel.puzzleIsBeingSaved().or((ObservableBooleanValue)this.applicationViewModel.solverRunning()).not();
        this.view.onSuggestionSelected().set(suggestion -> {
            if (editionAllowed.get()) {
                viewModel.currentSlotContent(suggestion);
            }
        });
    }

    private void initializeDictionaryBindings() {
        DictionariesViewModel viewModel = this.applicationViewModel.dictionaryViewModel();
        this.view.dictionariesProperty().set((Object)viewModel.dictionariesProperty());
        this.view.wordsProperty().set((Object)viewModel.wordsProperty());
        this.view.suggestionsProperty().set((Object)viewModel.suggestionsProperty());
        viewModel.selectedDictionariesProperty().addListener(this::onSelectedDictionaryChange);
    }

    private void onSelectedDictionaryChange(ListChangeListener.Change<? extends DictionaryViewModel> change) {
        while (change.next()) {
            if (!change.wasAdded()) continue;
            change.getAddedSubList().forEach(arg_0 -> ((DictionaryController)this.dictionaryController).listDictionaryEntries(arg_0));
        }
    }

    private void initializeSolverConfigurationBindings() {
        SolverConfigurationViewModel viewModel = this.applicationViewModel.solverConfigurationViewModel();
        this.view.solversProperty().set((Object)viewModel.availableSolversProperty());
        viewModel.selectedSolverProperty().bind((ObservableValue)this.view.selectedSolverProperty());
        viewModel.fillCluesOnSuccessProperty().bind((ObservableValue)this.view.fillClueOnSolverSuccessProperty());
    }

    private void initializeSolverProgressBindings() {
        SolverProgressViewModel solverProgressViewModel = this.applicationViewModel.solverProgressViewModel();
        this.view.solverProgressIndicatorVisibleProperty().bind((ObservableValue)solverProgressViewModel.solverRunningProperty());
        this.view.solverProgressIndicatorValueProperty().bind((ObservableValue)solverProgressViewModel.solverProgressProperty());
    }

    private void initializeOtherSolverBindings() {
        BooleanProperty solverRunning = this.applicationViewModel.solverRunning();
        BooleanProperty clueServiceIsRunning = this.applicationViewModel.clueServiceIsRunning();
        BooleanProperty puzzleIsBeingSaved = this.applicationViewModel.puzzleIsBeingSaved();
        this.view.gridEditionDisableProperty().bind((ObservableValue)solverRunning.or((ObservableBooleanValue)puzzleIsBeingSaved).or((ObservableBooleanValue)clueServiceIsRunning));
        this.view.solveButtonTextProperty().bind((ObservableValue)new When((ObservableBooleanValue)solverRunning).then(this.resources.getString("stop-solving-button")).otherwise(this.resources.getString("start-solving-button")));
        this.view.onSolveButtonActionProperty().set(event -> this.onSolveButtonAction());
        ReadOnlyListProperty selectedDictionaries = this.applicationViewModel.dictionaryViewModel().selectedDictionariesProperty();
        ReadOnlyMapProperty grid = this.applicationViewModel.crosswordGridViewModel().boxesProperty();
        this.view.solveButtonDisableProperty().bind((ObservableValue)solverRunning.not().and((ObservableBooleanValue)selectedDictionaries.emptyProperty().or((ObservableBooleanValue)grid.emptyProperty()).or((ObservableBooleanValue)clueServiceIsRunning)));
    }

    private void onSolveButtonAction() {
        if (!this.applicationViewModel.solverRunning().get()) {
            this.solverController.startSolver();
        } else {
            this.solverController.stopSolver();
        }
    }

    private void initializeNavigationBindings() {
        this.view.onBackToPuzzleSelectionButtonActionProperty().set(e -> {
            this.sceneSwitcher.switchToWelcomeScreen();
            this.applicationViewModel.puzzleEditionViewModel().reset();
            this.view.resetLateralPanePositions();
        });
    }

    private void initializeClueBindings() {
        CluesViewModel cluesViewModel = this.applicationViewModel.puzzleEditionViewModel().cluesViewModel();
        this.view.acrossCluesProperty().set((Object)cluesViewModel.acrossCluesProperty());
        this.view.downCluesProperty().set((Object)cluesViewModel.downCluesProperty());
        this.view.selectedAcrossClueIndexProperty().bindBidirectional((Property)cluesViewModel.selectedAcrossClueIndexProperty());
        this.view.selectedDownClueIndexProperty().bindBidirectional((Property)cluesViewModel.selectedDownClueIndexProperty());
        this.view.onFillClueButtonActionProperty().set(event -> this.clueController.getClueForCurrentSlot());
        this.view.clueEditionDisableProperty().bind((ObservableValue)cluesViewModel.clueServiceIsRunningProperty());
        this.view.fillClueButtonHideProperty().bind((ObservableValue)cluesViewModel.clueProvidersProperty().emptyProperty());
        ReadOnlyStringProperty slotContentProperty = this.applicationViewModel.crosswordGridViewModel().currentSlotContentProperty();
        BooleanBinding slotEmpty = slotContentProperty.isEmpty();
        BooleanBinding slotPartiallyFilled = Bindings.createBooleanBinding(() -> ((String)slotContentProperty.get()).contains("."), (Observable[])new Observable[]{slotContentProperty});
        this.view.fillClueButtonDisableProperty().bind((ObservableValue)slotEmpty.or((ObservableBooleanValue)slotPartiallyFilled));
    }

    private void populateModels() {
        this.dictionaryController.listDictionaries();
        this.solverController.listSolvers();
        this.clueController.listClueProviders();
        this.puzzleController.listPuzzleEncoders();
    }
}

