/*
 * Decompiled with CFR 0.152.
 */
package re.belv.croiseur.gui;

import java.io.File;
import java.util.List;
import java.util.ResourceBundle;
import java.util.concurrent.Executor;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.stage.FileChooser;
import re.belv.croiseur.api.puzzle.PuzzleService;
import re.belv.croiseur.gui.SceneSwitcher;
import re.belv.croiseur.gui.controller.puzzle.PuzzleController;
import re.belv.croiseur.gui.view.SavedPuzzleSelector;
import re.belv.croiseur.gui.view.model.PuzzleCodecsViewModel;
import re.belv.croiseur.gui.view.model.PuzzleEditionViewModel;
import re.belv.croiseur.gui.view.model.PuzzleSelectionViewModel;

final class WelcomeScreenController {
    private final PuzzleSelectionViewModel puzzleSelectionViewModel;
    private final PuzzleCodecsViewModel puzzleCodecsViewModel;
    private final PuzzleController puzzleController;
    private final FileChooser fileChooser;
    private final SceneSwitcher sceneSwitcher;
    @FXML
    private SavedPuzzleSelector selectorView;
    @FXML
    private ResourceBundle resources;

    WelcomeScreenController(PuzzleSelectionViewModel puzzleSelectionViewModelArg, PuzzleEditionViewModel puzzleEditionViewModel, PuzzleCodecsViewModel puzzleCodecsViewModelArg, PuzzleService puzzleService, SceneSwitcher sceneSwitcherArg, Executor executor) {
        this.puzzleSelectionViewModel = puzzleSelectionViewModelArg;
        this.puzzleCodecsViewModel = puzzleCodecsViewModelArg;
        this.puzzleController = new PuzzleController(puzzleSelectionViewModelArg, puzzleEditionViewModel, puzzleService, executor);
        this.fileChooser = new FileChooser();
        this.sceneSwitcher = sceneSwitcherArg;
    }

    @FXML
    private void initialize() {
        this.initializeListViewBindings();
        this.initializeFileChooserBindings();
        this.initializeButtonsBindings();
        this.populateModels();
    }

    private void initializeListViewBindings() {
        this.selectorView.recentPuzzles().set((Object)this.puzzleSelectionViewModel.availablePuzzlesProperty());
        this.puzzleSelectionViewModel.selectedPuzzleProperty().bind((ObservableValue)this.selectorView.selectedPuzzleProperty());
    }

    private void initializeFileChooserBindings() {
        this.fileChooser.setTitle(this.resources.getString("import-filechooser-title"));
        this.puzzleCodecsViewModel.decodersProperty().addListener(observable -> {
            List<FileChooser.ExtensionFilter> extensionFilters = this.puzzleCodecsViewModel.decodersProperty().stream().map(codec -> new FileChooser.ExtensionFilter(codec.name(), codec.extensions())).toList();
            this.fileChooser.getExtensionFilters().setAll(extensionFilters);
        });
    }

    private void initializeButtonsBindings() {
        this.selectorView.onNewPuzzleButtonActionProperty().set(e -> this.onNewPuzzleButtonAction());
        this.selectorView.onOpenSelectedPuzzleButtonActionProperty().set(e -> this.onOpenPuzzleButtonAction());
        this.selectorView.onImportPuzzleButtonActionProperty().set(e -> this.onImportPuzzleButtonAction());
        this.selectorView.onDeleteSelectedPuzzleButtonActionProperty().set(e -> this.onDeletePuzzleButtonAction());
    }

    private void onNewPuzzleButtonAction() {
        this.switchToEditorView();
    }

    private void onImportPuzzleButtonAction() {
        File selectedFile = this.fileChooser.showOpenDialog(this.selectorView.getScene().getWindow());
        if (selectedFile != null) {
            List selectedExtensions = this.fileChooser.getSelectedExtensionFilter().getExtensions();
            String selectedFormat = selectedExtensions.isEmpty() ? "unknown" : (String)selectedExtensions.get(0);
            this.puzzleController.importPuzzle(selectedFile, selectedFormat);
        }
    }

    private void onOpenPuzzleButtonAction() {
        this.puzzleController.loadSelectedPuzzle();
        this.switchToEditorView();
    }

    private void switchToEditorView() {
        this.sceneSwitcher.switchToEditorView();
    }

    private void onDeletePuzzleButtonAction() {
        this.puzzleController.deleteSelectedPuzzle();
    }

    private void populateModels() {
        this.puzzleController.listPuzzles();
        this.puzzleController.listPuzzleDecoders();
    }
}

