/*
 * Decompiled with CFR 0.152.
 */
package re.belv.croiseur.dictionary.xml.codec;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;

public record DictionaryHeader(Locale locale, Map<Locale, String> names, Map<Locale, String> descriptions) {

    static final class Builder {
        private final Map<Locale, String> names = new HashMap<Locale, String>();
        private final Map<Locale, String> descriptions = new HashMap<Locale, String>();
        private Locale locale = null;

        Builder() {
        }

        Builder setLocale(Locale localeArg) {
            if (this.locale != null) {
                throw new IllegalStateException("Locale already set");
            }
            this.locale = localeArg;
            return this;
        }

        Builder addName(Locale locale, String name) {
            this.names.put(locale, name);
            return this;
        }

        Builder addDescription(Locale locale, String description) {
            this.descriptions.put(locale, description);
            return this;
        }

        DictionaryHeader build() {
            Objects.requireNonNull(this.locale, "Locale not parsed, cannot build dictionary header model");
            if (this.names.isEmpty()) {
                throw new IllegalArgumentException("No name parsed, cannot build dictionary header model");
            }
            if (this.descriptions.isEmpty()) {
                throw new IllegalArgumentException("No description parsed, cannot build dictionary header model");
            }
            return new DictionaryHeader(this.locale, this.names, this.descriptions);
        }
    }
}

