/*
 * Decompiled with CFR 0.152.
 */
package re.belv.croiseur.dictionary.xml.codec;

import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;
import java.util.Optional;
import javax.xml.stream.StreamFilter;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import re.belv.croiseur.dictionary.xml.codec.AutoCloseableXMLStreamReader;
import re.belv.croiseur.dictionary.xml.codec.DictionaryHeader;
import re.belv.croiseur.dictionary.xml.codec.InputStreamSupplier;

final class DictionaryHeaderReader {
    private static final StreamFilter DICTIONARY_HEADER_STREAM_FILTER = reader -> {
        if (!reader.isStartElement()) {
            return false;
        }
        String elementName = reader.getLocalName();
        return "locale".equals(elementName) || "name".equals(elementName) || "description".equals(elementName) || "words".equals(elementName);
    };
    private final XMLInputFactory xmlInputFactory;
    private final InputStreamSupplier dictionaryStream;

    DictionaryHeaderReader(XMLInputFactory xmlInputFactoryArg, InputStreamSupplier dictionaryStreamArg) {
        this.xmlInputFactory = xmlInputFactoryArg;
        this.dictionaryStream = dictionaryStreamArg;
    }

    private static void parseDescription(XMLStreamReader xmlStreamReader, DictionaryHeader.Builder headerBuilder) throws XMLStreamException {
        Locale lang = Optional.ofNullable(xmlStreamReader.getAttributeValue(0)).map(Locale::forLanguageTag).orElse(Locale.ENGLISH);
        String content = xmlStreamReader.getElementText();
        headerBuilder.addDescription(lang, content);
    }

    private static void parseName(XMLStreamReader xmlStreamReader, DictionaryHeader.Builder headerBuilder) throws XMLStreamException {
        Locale lang = Optional.ofNullable(xmlStreamReader.getAttributeValue(0)).map(Locale::forLanguageTag).orElse(Locale.ENGLISH);
        String content = xmlStreamReader.getElementText();
        headerBuilder.addName(lang, content);
    }

    private static void parseLocale(XMLStreamReader xmlStreamReader, DictionaryHeader.Builder headerBuilder) throws XMLStreamException {
        Locale locale = Locale.forLanguageTag(xmlStreamReader.getElementText());
        headerBuilder.setLocale(locale);
    }

    DictionaryHeader read() throws XMLStreamException, IOException {
        try (InputStream is = this.dictionaryStream.get();){
            DictionaryHeader dictionaryHeader;
            block25: {
                AutoCloseableXMLStreamReader reader = this.createReader(is);
                try {
                    DictionaryHeader.Builder headerBuilder = new DictionaryHeader.Builder();
                    boolean headerEndReached = false;
                    block22: while (!headerEndReached && reader.hasNext()) {
                        String elementName;
                        switch (elementName = reader.getLocalName()) {
                            case "locale": {
                                DictionaryHeaderReader.parseLocale(reader, headerBuilder);
                                break;
                            }
                            case "name": {
                                DictionaryHeaderReader.parseName(reader, headerBuilder);
                                break;
                            }
                            case "description": {
                                DictionaryHeaderReader.parseDescription(reader, headerBuilder);
                                break;
                            }
                            case "words": {
                                headerEndReached = true;
                                continue block22;
                            }
                            default: {
                                throw new XMLStreamException("Illegal element read");
                            }
                        }
                        reader.next();
                    }
                    dictionaryHeader = headerBuilder.build();
                    if (reader == null) break block25;
                }
                catch (Throwable throwable) {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                reader.close();
            }
            return dictionaryHeader;
        }
    }

    private AutoCloseableXMLStreamReader createReader(InputStream is) throws XMLStreamException {
        XMLStreamReader baseReader = this.xmlInputFactory.createXMLStreamReader(is);
        XMLStreamReader filteredReader = this.xmlInputFactory.createFilteredReader(baseReader, DICTIONARY_HEADER_STREAM_FILTER);
        return new AutoCloseableXMLStreamReader(filteredReader);
    }
}

