/*
 * Decompiled with CFR 0.152.
 */
package re.belv.croiseur.dictionary.xml.codec;

import java.io.IOException;
import java.io.InputStream;
import java.util.stream.Stream;
import javax.xml.stream.StreamFilter;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import re.belv.croiseur.dictionary.xml.codec.AutoCloseableXMLStreamReader;
import re.belv.croiseur.dictionary.xml.codec.InputStreamSupplier;

final class DictionaryWordsReader {
    private static final StreamFilter WORDS_STREAM_FILTER = reader -> reader.isStartElement() && "word".equals(reader.getLocalName());
    private final XMLInputFactory xmlInputFactory;
    private final InputStreamSupplier dictionaryStream;

    DictionaryWordsReader(XMLInputFactory xmlInputFactoryArg, InputStreamSupplier dictionaryStreamArg) {
        this.xmlInputFactory = xmlInputFactoryArg;
        this.dictionaryStream = dictionaryStreamArg;
    }

    Stream<String> read() throws IOException, XMLStreamException {
        try (InputStream inputStream = this.dictionaryStream.get();){
            Stream<String> stream;
            block13: {
                AutoCloseableXMLStreamReader reader = this.createReader(inputStream);
                try {
                    Stream.Builder<String> streamBuilder = Stream.builder();
                    while (reader.hasNext()) {
                        String word = reader.getElementText();
                        streamBuilder.add(word);
                        reader.next();
                    }
                    stream = streamBuilder.build();
                    if (reader == null) break block13;
                }
                catch (Throwable throwable) {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                reader.close();
            }
            return stream;
        }
    }

    private AutoCloseableXMLStreamReader createReader(InputStream is) throws XMLStreamException {
        XMLStreamReader baseReader = this.xmlInputFactory.createXMLStreamReader(is);
        XMLStreamReader filteredReader = this.xmlInputFactory.createFilteredReader(baseReader, WORDS_STREAM_FILTER);
        return new AutoCloseableXMLStreamReader(filteredReader);
    }
}

