/*
 * Decompiled with CFR 0.152.
 */
package re.belv.croiseur.dictionary.xml.codec;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import re.belv.croiseur.dictionary.xml.codec.AutocloseableXMLStreamWriter;
import re.belv.croiseur.dictionary.xml.codec.Dictionary;
import re.belv.croiseur.dictionary.xml.codec.DictionaryHeader;
import re.belv.croiseur.dictionary.xml.codec.DictionaryWriteException;

public final class DictionaryWriter {
    private DictionaryWriter() {
    }

    private static void writeHeader(DictionaryHeader header, XMLStreamWriter writer) throws XMLStreamException {
        DictionaryWriter.writeLocale(header.locale(), writer);
        for (Map.Entry<Locale, String> entry : header.names().entrySet()) {
            DictionaryWriter.writeName(entry.getKey(), entry.getValue(), writer);
        }
        for (Map.Entry<Locale, String> entry : header.descriptions().entrySet()) {
            DictionaryWriter.writeDescription(entry.getKey(), entry.getValue(), writer);
        }
    }

    private static void writeDescription(Locale lang, String description, XMLStreamWriter writer) throws XMLStreamException {
        writer.writeStartElement("description");
        if (!lang.equals(Locale.ENGLISH)) {
            writer.writeAttribute("xml:lang", lang.toLanguageTag());
        }
        writer.writeCharacters(description);
        writer.writeEndElement();
    }

    private static void writeName(Locale lang, String name, XMLStreamWriter writer) throws XMLStreamException {
        writer.writeStartElement("name");
        if (!lang.equals(Locale.ENGLISH)) {
            writer.writeAttribute("xml:lang", lang.toLanguageTag());
        }
        writer.writeCharacters(name);
        writer.writeEndElement();
    }

    private static void writeLocale(Locale locale, XMLStreamWriter writer) throws XMLStreamException {
        writer.writeStartElement("locale");
        writer.writeCharacters(locale.toLanguageTag());
        writer.writeEndElement();
    }

    private static void writeWord(String word, XMLStreamWriter writer) throws XMLStreamException {
        writer.writeStartElement("word");
        writer.writeCharacters(word);
        writer.writeEndElement();
    }

    private static void writeWords(List<String> words, XMLStreamWriter writer) throws XMLStreamException {
        writer.writeStartElement("words");
        for (String word : words) {
            DictionaryWriter.writeWord(word, writer);
        }
        writer.writeEndElement();
    }

    public static void write(OutputStream os, Dictionary dictionary) throws DictionaryWriteException {
        try (BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(os);
             AutocloseableXMLStreamWriter writer = DictionaryWriter.createWriter(bufferedOutputStream);){
            writer.writeStartDocument();
            DictionaryWriter.writeDictionaryStartElement(writer);
            DictionaryWriter.writeHeader(dictionary.header(), writer);
            DictionaryWriter.writeWords(dictionary.words(), writer);
            writer.writeEndElement();
            writer.writeEndDocument();
            writer.flush();
        }
        catch (IOException | XMLStreamException e) {
            throw new DictionaryWriteException(e);
        }
    }

    private static void writeDictionaryStartElement(XMLStreamWriter writer) throws XMLStreamException {
        writer.writeStartElement("tns", "dictionary", "http://www.example.org/dictionary");
        writer.writeAttribute("xmlns", "", "tns", "http://www.example.org/dictionary");
        writer.writeAttribute("xmlns", "", "xsi", "http://www.w3.org/2001/XMLSchema-instance");
        writer.writeAttribute("xsi", "", "schemaLocation", "http://www.example.org/dictionary dictionary.xsd");
    }

    private static AutocloseableXMLStreamWriter createWriter(OutputStream os) throws XMLStreamException {
        XMLStreamWriter writer = XMLOutputFactory.newInstance().createXMLStreamWriter(os, Charset.defaultCharset().name());
        return new AutocloseableXMLStreamWriter(writer);
    }
}

