/*
 * Decompiled with CFR 0.152.
 */
package re.belv.croiseur.dictionary.common;

import java.text.Normalizer;
import java.util.regex.Pattern;
import re.belv.croiseur.dictionary.common.StringTransformer;

public final class StringTransformers {
    private static final Pattern ACCENTS = Pattern.compile("\\p{InCombiningDiacriticalMarks}+");
    private static final StringTransformer REMOVE_ACCENTUATION = in -> {
        String normalized = Normalizer.normalize(in, Normalizer.Form.NFD);
        return ACCENTS.matcher(normalized).replaceAll("");
    };
    private static final Pattern PUNCTUATION = Pattern.compile("\\p{Punct}");
    private static final StringTransformer REMOVE_PUNCTUATION = in -> PUNCTUATION.matcher((CharSequence)in).replaceAll("");
    private static final StringTransformer REMOVE_BLANKS = in -> in.replace(" ", "");

    private StringTransformers() {
    }

    public static StringTransformer removeAccentuation() {
        return REMOVE_ACCENTUATION;
    }

    public static StringTransformer removePunctuation() {
        return REMOVE_PUNCTUATION;
    }

    public static StringTransformer removeBlanks() {
        return REMOVE_BLANKS;
    }

    public static StringTransformer toUpperCase() {
        return String::toUpperCase;
    }

    public static StringTransformer toAcceptableCrosswordEntry() {
        return s -> StringTransformers.removeBlanks().andThen(StringTransformers.removeAccentuation()).andThen(StringTransformers.removePunctuation()).andThen(StringTransformers.toUpperCase()).apply((String)s);
    }
}

