/*
 * Decompiled with CFR 0.152.
 */
package re.belv.croiseur.dictionary.common.util;

import java.lang.ref.SoftReference;
import java.util.Objects;
import java.util.function.Supplier;

public final class Lazy<T>
implements Supplier<T> {
    private final Supplier<T> supplier;
    private SoftReference<T> cached;

    private Lazy(Supplier<T> supplierArg) {
        this.supplier = Objects.requireNonNull(supplierArg);
        this.cached = null;
    }

    public static <T> Lazy<T> of(Supplier<T> supplierArg) {
        return new Lazy<T>(supplierArg);
    }

    @Override
    public T get() {
        T cachedValue = this.cachedValue();
        return cachedValue != null ? cachedValue : this.retrieveValue();
    }

    private T cachedValue() {
        return this.cached != null ? (T)this.cached.get() : null;
    }

    private T retrieveValue() {
        T value = this.supplier.get();
        this.cached = new SoftReference<T>(value);
        return value;
    }
}

