/*
 * Decompiled with CFR 0.152.
 */
package re.belv.croiseur.solver.sat;

import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.function.IntPredicate;
import org.sat4j.specs.IVecInt;
import re.belv.croiseur.solver.sat.Alphabet;
import re.belv.croiseur.solver.sat.Grid;
import re.belv.croiseur.solver.sat.Pos;

final class Variables {
    static final int CELL_VALUE_COUNT = Alphabet.letterCount() + 1;
    static final int BLOCK_INDEX = Alphabet.letterCount();
    private final Grid grid;
    private final int wordCount;

    Variables(Grid gridArg, int wordCountArg) {
        this.grid = gridArg;
        this.wordCount = wordCountArg;
    }

    int count() {
        return this.representingCellCount() + this.representingSlotCount();
    }

    int representingCellCount() {
        return this.grid.columnCount() * this.grid.rowCount() * CELL_VALUE_COUNT;
    }

    int representingSlotCount() {
        return this.grid.slotCount() * this.wordCount;
    }

    int representingCell(int row, int column, int value) {
        return row * this.grid.columnCount() * CELL_VALUE_COUNT + column * CELL_VALUE_COUNT + value + 1;
    }

    int representingSlot(int slotIndex, int wordIndex) {
        return this.representingCellCount() + slotIndex * this.wordCount + wordIndex + 1;
    }

    char[][] backToGrid(IntPredicate model) {
        char[][] outGrid = new char[this.grid.rowCount()][this.grid.columnCount()];
        for (int row = 0; row < this.grid.rowCount(); ++row) {
            block1: for (int column = 0; column < this.grid.columnCount(); ++column) {
                for (int value = 0; value < CELL_VALUE_COUNT; ++value) {
                    int variable = this.representingCell(row, column, value);
                    if (!model.test(variable)) continue;
                    outGrid[row][column] = value == BLOCK_INDEX ? 35 : (int)Alphabet.letterAt(value);
                    continue block1;
                }
            }
        }
        return outGrid;
    }

    Set<Pos> backToPositions(IVecInt literals) {
        HashSet<Pos> positions = new HashSet<Pos>();
        for (int i = 0; i < literals.size(); ++i) {
            int literal = literals.get(i);
            this.backToPosition(literal).ifPresent(positions::add);
        }
        return positions;
    }

    private Optional<Pos> backToPosition(int literal) {
        int variable = Math.abs(literal);
        if (variable > this.representingCellCount()) {
            return Optional.empty();
        }
        int column = (variable - 1) / CELL_VALUE_COUNT % this.grid.columnCount();
        int row = (variable - 1) / (this.grid.columnCount() * CELL_VALUE_COUNT);
        return Optional.of(new Pos(column, row));
    }
}

