/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.openai.models;

import com.azure.ai.openai.models.OnYourDataAuthenticationOptions;
import com.azure.ai.openai.models.OnYourDataAuthenticationType;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class OnYourDataEncodedApiKeyAuthenticationOptions
extends OnYourDataAuthenticationOptions {
    private final String encodedApiKey;
    private OnYourDataAuthenticationType type = OnYourDataAuthenticationType.ENCODED_API_KEY;

    public OnYourDataEncodedApiKeyAuthenticationOptions(String encodedApiKey) {
        this.encodedApiKey = encodedApiKey;
    }

    public String getEncodedApiKey() {
        return this.encodedApiKey;
    }

    @Override
    public OnYourDataAuthenticationType getType() {
        return this.type;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("encoded_api_key", this.encodedApiKey);
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        return jsonWriter.writeEndObject();
    }

    public static OnYourDataEncodedApiKeyAuthenticationOptions fromJson(JsonReader jsonReader) throws IOException {
        return (OnYourDataEncodedApiKeyAuthenticationOptions)jsonReader.readObject(reader -> {
            String encodedApiKey = null;
            OnYourDataAuthenticationType type = OnYourDataAuthenticationType.ENCODED_API_KEY;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("encoded_api_key".equals(fieldName)) {
                    encodedApiKey = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    type = OnYourDataAuthenticationType.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            OnYourDataEncodedApiKeyAuthenticationOptions deserializedOnYourDataEncodedApiKeyAuthenticationOptions = new OnYourDataEncodedApiKeyAuthenticationOptions(encodedApiKey);
            deserializedOnYourDataEncodedApiKeyAuthenticationOptions.type = type;
            return deserializedOnYourDataEncodedApiKeyAuthenticationOptions;
        });
    }
}

