/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.openai.models;

import com.azure.ai.openai.models.OpenAIFile;
import com.azure.ai.openai.models.UploadObject;
import com.azure.ai.openai.models.UploadPurpose;
import com.azure.ai.openai.models.UploadStatus;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;

public final class Upload
implements JsonSerializable<Upload> {
    private final String id;
    private final long createdAt;
    private final String filename;
    private final long bytes;
    private final UploadPurpose purpose;
    private final UploadStatus status;
    private final long expiresAt;
    private UploadObject object;
    private OpenAIFile file;

    public String getId() {
        return this.id;
    }

    public OffsetDateTime getCreatedAt() {
        return OffsetDateTime.ofInstant(Instant.ofEpochSecond(this.createdAt), ZoneOffset.UTC);
    }

    public String getFilename() {
        return this.filename;
    }

    public long getBytes() {
        return this.bytes;
    }

    public UploadPurpose getPurpose() {
        return this.purpose;
    }

    public UploadStatus getStatus() {
        return this.status;
    }

    public OffsetDateTime getExpiresAt() {
        return OffsetDateTime.ofInstant(Instant.ofEpochSecond(this.expiresAt), ZoneOffset.UTC);
    }

    public UploadObject getObject() {
        return this.object;
    }

    public OpenAIFile getFile() {
        return this.file;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id);
        jsonWriter.writeLongField("created_at", this.createdAt);
        jsonWriter.writeStringField("filename", this.filename);
        jsonWriter.writeLongField("bytes", this.bytes);
        jsonWriter.writeStringField("purpose", this.purpose == null ? null : this.purpose.toString());
        jsonWriter.writeStringField("status", this.status == null ? null : this.status.toString());
        jsonWriter.writeLongField("expires_at", this.expiresAt);
        jsonWriter.writeStringField("object", this.object == null ? null : this.object.toString());
        jsonWriter.writeJsonField("file", (JsonSerializable)this.file);
        return jsonWriter.writeEndObject();
    }

    public static Upload fromJson(JsonReader jsonReader) throws IOException {
        return (Upload)jsonReader.readObject(reader -> {
            String id = null;
            OffsetDateTime createdAt = null;
            String filename = null;
            long bytes = 0L;
            UploadPurpose purpose = null;
            UploadStatus status = null;
            OffsetDateTime expiresAt = null;
            UploadObject object = null;
            OpenAIFile file = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    id = reader.getString();
                    continue;
                }
                if ("created_at".equals(fieldName)) {
                    createdAt = OffsetDateTime.ofInstant(Instant.ofEpochSecond(reader.getLong()), ZoneOffset.UTC);
                    continue;
                }
                if ("filename".equals(fieldName)) {
                    filename = reader.getString();
                    continue;
                }
                if ("bytes".equals(fieldName)) {
                    bytes = reader.getLong();
                    continue;
                }
                if ("purpose".equals(fieldName)) {
                    purpose = UploadPurpose.fromString(reader.getString());
                    continue;
                }
                if ("status".equals(fieldName)) {
                    status = UploadStatus.fromString(reader.getString());
                    continue;
                }
                if ("expires_at".equals(fieldName)) {
                    expiresAt = OffsetDateTime.ofInstant(Instant.ofEpochSecond(reader.getLong()), ZoneOffset.UTC);
                    continue;
                }
                if ("object".equals(fieldName)) {
                    object = UploadObject.fromString(reader.getString());
                    continue;
                }
                if ("file".equals(fieldName)) {
                    file = OpenAIFile.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            Upload deserializedUpload = new Upload(id, createdAt, filename, bytes, purpose, status, expiresAt);
            deserializedUpload.object = object;
            deserializedUpload.file = file;
            return deserializedUpload;
        });
    }

    private Upload(String id, OffsetDateTime createdAt, String filename, long bytes, UploadPurpose purpose, UploadStatus status, OffsetDateTime expiresAt) {
        this.id = id;
        this.createdAt = createdAt == null ? 0L : createdAt.toEpochSecond();
        this.filename = filename;
        this.bytes = bytes;
        this.purpose = purpose;
        this.status = status;
        this.expiresAt = expiresAt == null ? 0L : expiresAt.toEpochSecond();
    }
}

