/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.openai.responses.models;

import com.azure.ai.openai.responses.models.ResponsesComputerCallActionType;
import com.azure.ai.openai.responses.models.ResponsesComputerCallClickButtonType;
import com.azure.ai.openai.responses.models.ResponsesComputerCallItemAction;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class ResponsesComputerCallClickAction
extends ResponsesComputerCallItemAction {
    private ResponsesComputerCallActionType type = ResponsesComputerCallActionType.CLICK;
    private final ResponsesComputerCallClickButtonType button;
    private final int x;
    private final int y;

    public ResponsesComputerCallClickAction(ResponsesComputerCallClickButtonType button, int x, int y) {
        this.button = button;
        this.x = x;
        this.y = y;
    }

    @Override
    public ResponsesComputerCallActionType getType() {
        return this.type;
    }

    public ResponsesComputerCallClickButtonType getButton() {
        return this.button;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("button", this.button == null ? null : this.button.toString());
        jsonWriter.writeIntField("x", this.x);
        jsonWriter.writeIntField("y", this.y);
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        return jsonWriter.writeEndObject();
    }

    public static ResponsesComputerCallClickAction fromJson(JsonReader jsonReader) throws IOException {
        return (ResponsesComputerCallClickAction)jsonReader.readObject(reader -> {
            ResponsesComputerCallClickButtonType button = null;
            int x = 0;
            int y = 0;
            ResponsesComputerCallActionType type = ResponsesComputerCallActionType.CLICK;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("button".equals(fieldName)) {
                    button = ResponsesComputerCallClickButtonType.fromString(reader.getString());
                    continue;
                }
                if ("x".equals(fieldName)) {
                    x = reader.getInt();
                    continue;
                }
                if ("y".equals(fieldName)) {
                    y = reader.getInt();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    type = ResponsesComputerCallActionType.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            ResponsesComputerCallClickAction deserializedResponsesComputerCallClickAction = new ResponsesComputerCallClickAction(button, x, y);
            deserializedResponsesComputerCallClickAction.type = type;
            return deserializedResponsesComputerCallClickAction;
        });
    }
}

