/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.openai.responses.models;

import com.azure.ai.openai.responses.models.ResponsesContent;
import com.azure.ai.openai.responses.models.ResponsesContentType;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class ResponsesInputContentText
extends ResponsesContent {
    private ResponsesContentType type = ResponsesContentType.INPUT_TEXT;
    private final String text;

    public ResponsesInputContentText(String text) {
        this.text = text;
    }

    @Override
    public ResponsesContentType getType() {
        return this.type;
    }

    public String getText() {
        return this.text;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("text", this.text);
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        return jsonWriter.writeEndObject();
    }

    public static ResponsesInputContentText fromJson(JsonReader jsonReader) throws IOException {
        return (ResponsesInputContentText)jsonReader.readObject(reader -> {
            String text = null;
            ResponsesContentType type = ResponsesContentType.INPUT_TEXT;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("text".equals(fieldName)) {
                    text = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    type = ResponsesContentType.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            ResponsesInputContentText deserializedResponsesInputContentText = new ResponsesInputContentText(text);
            deserializedResponsesInputContentText.type = type;
            return deserializedResponsesInputContentText;
        });
    }
}

