/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.openai.responses.models;

import com.azure.ai.openai.responses.models.ResponsesContent;
import com.azure.ai.openai.responses.models.ResponsesStreamEvent;
import com.azure.ai.openai.responses.models.ResponsesStreamEventType;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class ResponsesStreamEventContentPartAdded
extends ResponsesStreamEvent {
    private ResponsesStreamEventType type = ResponsesStreamEventType.RESPONSE_CONTENT_PART_ADDED;
    private final String itemId;
    private final int outputIndex;
    private final int contentIndex;
    private final ResponsesContent part;

    private ResponsesStreamEventContentPartAdded(String itemId, int outputIndex, int contentIndex, ResponsesContent part) {
        this.itemId = itemId;
        this.outputIndex = outputIndex;
        this.contentIndex = contentIndex;
        this.part = part;
    }

    @Override
    public ResponsesStreamEventType getType() {
        return this.type;
    }

    public String getItemId() {
        return this.itemId;
    }

    public int getOutputIndex() {
        return this.outputIndex;
    }

    public int getContentIndex() {
        return this.contentIndex;
    }

    public ResponsesContent getPart() {
        return this.part;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("item_id", this.itemId);
        jsonWriter.writeIntField("output_index", this.outputIndex);
        jsonWriter.writeIntField("content_index", this.contentIndex);
        jsonWriter.writeJsonField("part", (JsonSerializable)this.part);
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        return jsonWriter.writeEndObject();
    }

    public static ResponsesStreamEventContentPartAdded fromJson(JsonReader jsonReader) throws IOException {
        return (ResponsesStreamEventContentPartAdded)jsonReader.readObject(reader -> {
            String itemId = null;
            int outputIndex = 0;
            int contentIndex = 0;
            ResponsesContent part = null;
            ResponsesStreamEventType type = ResponsesStreamEventType.RESPONSE_CONTENT_PART_ADDED;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("item_id".equals(fieldName)) {
                    itemId = reader.getString();
                    continue;
                }
                if ("output_index".equals(fieldName)) {
                    outputIndex = reader.getInt();
                    continue;
                }
                if ("content_index".equals(fieldName)) {
                    contentIndex = reader.getInt();
                    continue;
                }
                if ("part".equals(fieldName)) {
                    part = ResponsesContent.fromJson(reader);
                    continue;
                }
                if ("type".equals(fieldName)) {
                    type = ResponsesStreamEventType.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            ResponsesStreamEventContentPartAdded deserializedResponsesStreamEventContentPartAdded = new ResponsesStreamEventContentPartAdded(itemId, outputIndex, contentIndex, part);
            deserializedResponsesStreamEventContentPartAdded.type = type;
            return deserializedResponsesStreamEventContentPartAdded;
        });
    }
}

