/*
 * Decompiled with CFR 0.152.
 */
package re.belv.croiseur.gui.view;

import java.util.List;
import java.util.ResourceBundle;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.css.CssMetaData;
import javafx.css.SimpleStyleableObjectProperty;
import javafx.css.Styleable;
import javafx.css.StyleableObjectProperty;
import javafx.css.StyleablePropertyFactory;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.Labeled;
import javafx.scene.control.ListCell;
import javafx.scene.control.TextArea;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.HBox;
import re.belv.croiseur.gui.view.FxmlLoaderHelper;
import re.belv.croiseur.gui.view.model.ClueViewModel;

final class ClueListCell
extends ListCell<ClueViewModel> {
    private static final StyleablePropertyFactory<ClueListCell> FACTORY = new StyleablePropertyFactory(Labeled.getClassCssMetaData());
    private static final CssMetaData<ClueListCell, IndexFormat> INDEX_FORMAT_CSS_METADATA = FACTORY.createEnumCssMetaData(IndexFormat.class, "-index-format", s -> s.indexFormat, (Enum)IndexFormat.ARABIC, false);
    private final StyleableObjectProperty<IndexFormat> indexFormat = new SimpleStyleableObjectProperty(INDEX_FORMAT_CSS_METADATA, (Object)this, "indexFormat", (Object)IndexFormat.ARABIC);
    private final BooleanProperty hideFillButton;
    private final BooleanProperty disableFillButton;
    @FXML
    private HBox containerHBox;
    @FXML
    private Label indexLabel;
    @FXML
    private TextArea textArea;
    @FXML
    private Button fillButton;

    ClueListCell() {
        this.indexFormat.addListener(observable -> this.updateItem((ClueViewModel)this.getItem(), this.isEmpty()));
        this.hideFillButton = new SimpleBooleanProperty((Object)this, "hideFillButton");
        this.hideFillButton.addListener(o -> this.updateItem((ClueViewModel)this.getItem(), this.isEmpty()));
        this.disableFillButton = new SimpleBooleanProperty((Object)this, "disableFillButton");
        this.disableFillButton.addListener(o -> this.updateItem((ClueViewModel)this.getItem(), this.isEmpty()));
        FxmlLoaderHelper.load((Object)this, ResourceBundle.getBundle(((Object)((Object)this)).getClass().getName()));
    }

    public ObjectProperty<EventHandler<ActionEvent>> onFillClueButtonActionProperty() {
        return this.fillButton.onActionProperty();
    }

    public BooleanProperty fillClueButtonDisableProperty() {
        return this.disableFillButton;
    }

    public BooleanProperty fillButtonHideProperty() {
        return this.hideFillButton;
    }

    public void startEdit() {
        if (!this.isEditable() || !this.getListView().isEditable()) {
            return;
        }
        super.startEdit();
        if (this.isEditing()) {
            this.textArea.setPromptText(this.itemToPromptText());
            this.textArea.setText(this.itemToText());
            this.textArea.selectAll();
            this.textArea.requestFocus();
        }
    }

    public void updateItem(ClueViewModel item, boolean empty) {
        super.updateItem((Object)item, empty);
        if (empty || item == null) {
            this.setGraphic(null);
        } else {
            this.indexLabel.setText(this.formattedIndex());
            this.textArea.setPromptText(this.itemToPromptText());
            this.textArea.setText(this.itemToText());
            this.fillButton.setVisible(this.isSelected() && !this.hideFillButton.get());
            this.fillButton.setDisable(this.disableFillButton.get() || !item.userContent().isEmpty());
            this.setGraphic((Node)this.containerHBox);
        }
    }

    public void cancelEdit() {
        super.cancelEdit();
        this.setGraphic((Node)this.containerHBox);
    }

    public List<CssMetaData<? extends Styleable, ?>> getControlCssMetaData() {
        return FACTORY.getCssMetaData();
    }

    @FXML
    private void initialize() {
        this.initializeTextArea();
    }

    private void initializeTextArea() {
        this.textArea.addEventFilter(KeyEvent.ANY, event -> {
            if (event.getCode() == KeyCode.ENTER) {
                this.commitEdit(this.itemFromText());
                event.consume();
            }
        });
        this.textArea.setOnKeyReleased(event -> {
            if (event.getCode() == KeyCode.ESCAPE) {
                this.cancelEdit();
                event.consume();
            }
        });
    }

    private ClueViewModel itemFromText() {
        return new ClueViewModel(this.textArea.getText());
    }

    private String itemToText() {
        return ((ClueViewModel)this.getItem()).userContent();
    }

    private String itemToPromptText() {
        String itemSystemContent = ((ClueViewModel)this.getItem()).systemContent();
        return itemSystemContent.isEmpty() ? ResourceBundle.getBundle(ClueListCell.class.getName()).getString("clue.none") : itemSystemContent;
    }

    private String formattedIndex() {
        int index = this.getIndex() + 1;
        return (switch (((IndexFormat)((Object)this.indexFormat.getValue())).ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> ClueListCell.arabicFormat(index);
            case 1 -> ClueListCell.romanFormat(index);
        }) + ".";
    }

    private static String arabicFormat(int index) {
        return Integer.toString(index);
    }

    private static String romanFormat(int index) {
        return "I".repeat(index).replace("IIIII", "V").replace("IIII", "IV").replace("VV", "X").replace("VIV", "IX").replace("XXXXX", "L").replace("XXXX", "XL").replace("LL", "C").replace("LXL", "XC").replace("CCCCC", "D").replace("CCCC", "CD").replace("DD", "M").replace("DCD", "CM");
    }

    private static enum IndexFormat {
        ARABIC,
        ROMAN;

    }
}

