/*
 * Decompiled with CFR 0.152.
 */
package re.belv.croiseur.gui.view;

import javafx.scene.control.Tooltip;
import javafx.scene.control.cell.CheckBoxListCell;
import javafx.util.StringConverter;
import re.belv.croiseur.gui.view.model.DictionaryViewModel;

final class DictionaryListCell
extends CheckBoxListCell<DictionaryViewModel> {
    private static final StringConverter<DictionaryViewModel> DICTIONARY_LIST_CELL_STRING_CONVERTER = new StringConverter<DictionaryViewModel>(){

        public String toString(DictionaryViewModel dictionaryViewModel) {
            return dictionaryViewModel.name();
        }

        public DictionaryViewModel fromString(String string) {
            throw new UnsupportedOperationException("Unused");
        }
    };
    private static final double TOOLTIP_MAX_WIDTH = 350.0;

    DictionaryListCell() {
        super(DictionaryViewModel::selectedProperty, DICTIONARY_LIST_CELL_STRING_CONVERTER);
        this.setPrefWidth(0.0);
    }

    public void updateItem(DictionaryViewModel item, boolean empty) {
        super.updateItem((Object)item, empty);
        if (empty || item == null) {
            this.setTooltip(null);
        } else {
            Tooltip tooltip = new Tooltip(item.name() + "\n\n" + item.description());
            tooltip.setMaxWidth(350.0);
            tooltip.setWrapText(true);
            this.setTooltip(tooltip);
        }
    }
}

