/*
 * Decompiled with CFR 0.152.
 */
package re.belv.croiseur.gui.view;

import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.stream.Stream;
import javafx.fxml.FXML;
import javafx.geometry.VPos;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.layout.HBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Font;
import javafx.scene.text.Text;
import javafx.scene.text.TextAlignment;
import re.belv.croiseur.gui.view.FxmlLoaderHelper;
import re.belv.croiseur.gui.view.javafx.scene.canvas.CanvasUtil;
import re.belv.croiseur.gui.view.model.GridCoord;
import re.belv.croiseur.gui.view.model.SavedPuzzleViewModel;

public final class SavedPuzzleCard
extends HBox {
    @FXML
    private Canvas thumbnail;
    @FXML
    private Text title;
    @FXML
    private Text author;
    @FXML
    private Text editor;
    @FXML
    private Text copyright;
    @FXML
    private Text date;

    public SavedPuzzleCard() {
        FxmlLoaderHelper.load((Object)this, ResourceBundle.getBundle(((Object)((Object)this)).getClass().getName()));
    }

    public void set(SavedPuzzleViewModel model) {
        this.title.setText(model.title());
        this.author.setText(model.author());
        this.editor.setText(model.editor());
        this.copyright.setText(model.copyright());
        this.date.setText(model.date());
        GridDrawer.draw(this.thumbnail, model);
    }

    public void reset() {
        GridDrawer.clear(this.thumbnail);
        Stream.of(this.title, this.author, this.editor, this.copyright, this.date).forEach(t -> t.setText(null));
    }

    private static final class GridDrawer {
        private static final String FONT_FAMILY = "Serif";
        private static final double FONT_SIZE_MAGIC = 2.2;
        private final Canvas canvas;
        private final Map<GridCoord, Character> filledBoxes;
        private final Set<GridCoord> shadedBoxes;
        private final int numberOfColumns;
        private final int numberOfRows;
        private final double gridWidth;
        private final double gridHeight;
        private final double boxWidth;
        private final double boxHeight;
        private final double verticalOffset;
        private final double horizontalOffset;

        private GridDrawer(Canvas canvas, SavedPuzzleViewModel grid) {
            this.canvas = canvas;
            this.filledBoxes = grid.filledBoxes();
            this.shadedBoxes = grid.shadedBoxes();
            this.numberOfColumns = grid.columnCount();
            this.numberOfRows = grid.rowCount();
            double exploitableWidth = canvas.getWidth() - CanvasUtil.pixelSize();
            double exploitableHeight = canvas.getHeight() - CanvasUtil.pixelSize();
            double columnPerRowRatio = (double)this.numberOfColumns / (double)this.numberOfRows;
            this.gridWidth = Math.min(exploitableWidth, exploitableWidth * columnPerRowRatio);
            this.gridHeight = Math.min(exploitableHeight, exploitableHeight / columnPerRowRatio);
            this.boxWidth = this.gridWidth / (double)this.numberOfColumns;
            this.boxHeight = this.gridHeight / (double)this.numberOfRows;
            this.horizontalOffset = (exploitableWidth - this.gridWidth) / 2.0;
            this.verticalOffset = (exploitableHeight - this.gridHeight) / 2.0;
        }

        static void draw(Canvas canvas, SavedPuzzleViewModel grid) {
            new GridDrawer(canvas, grid).draw();
        }

        static void clear(Canvas canvas) {
            canvas.getGraphicsContext2D().clearRect(0.0, 0.0, canvas.getWidth(), canvas.getHeight());
        }

        private void draw() {
            GridDrawer.clear(this.canvas);
            this.fillBackground();
            this.drawColumns();
            this.drawRows();
            this.drawShadedBoxes();
            this.drawFilledBoxes();
        }

        private void fillBackground() {
            GraphicsContext gc = this.canvas.getGraphicsContext2D();
            gc.setFill((Paint)Color.WHITE);
            gc.fillRect(this.x(0), this.y(0), this.gridWidth, this.gridHeight);
            gc.setFill((Paint)Color.BLACK);
        }

        private void drawColumns() {
            GraphicsContext gc = this.canvas.getGraphicsContext2D();
            double yStart = this.y(0);
            double yEnd = this.y(this.numberOfRows);
            for (int column = 0; column < this.numberOfColumns + 1; ++column) {
                gc.strokeLine(this.x(column), yStart, this.x(column), yEnd);
            }
        }

        private void drawRows() {
            GraphicsContext gc = this.canvas.getGraphicsContext2D();
            double xStart = this.x(0);
            double xEnd = this.x(this.numberOfColumns);
            for (int row = 0; row < this.numberOfRows + 1; ++row) {
                gc.strokeLine(xStart, this.y(row), xEnd, this.y(row));
            }
        }

        private void drawShadedBoxes() {
            GraphicsContext gc = this.canvas.getGraphicsContext2D();
            this.shadedBoxes.forEach(position -> gc.fillRect(this.x(position.column()), this.y(position.row()), this.boxWidth, this.boxHeight));
        }

        private void drawFilledBoxes() {
            GraphicsContext gc = this.canvas.getGraphicsContext2D();
            gc.setTextAlign(TextAlignment.CENTER);
            gc.setTextBaseline(VPos.CENTER);
            gc.setFont(Font.font((String)FONT_FAMILY, (double)(this.boxHeight / 2.2)));
            this.filledBoxes.forEach((position, letter) -> gc.fillText(String.valueOf(letter), this.x(position.column()) + this.boxWidth / 2.0, this.y(position.row()) + this.boxHeight / 2.0));
        }

        private double x(int columnNumber) {
            return CanvasUtil.snapToPixel(this.boxWidth * (double)columnNumber + this.horizontalOffset);
        }

        private double y(int rowNumber) {
            return CanvasUtil.snapToPixel(this.boxHeight * (double)rowNumber + this.verticalOffset);
        }
    }
}

