/*
 * Decompiled with CFR 0.152.
 */
package re.belv.croiseur.solver.ginsberg.grid;

import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import re.belv.croiseur.common.puzzle.GridPosition;
import re.belv.croiseur.solver.ginsberg.core.Slot;
import re.belv.croiseur.solver.ginsberg.core.SlotIdentifier;
import re.belv.croiseur.solver.ginsberg.grid.Connectivity;
import re.belv.croiseur.solver.ginsberg.grid.Grid;
import re.belv.croiseur.solver.ginsberg.grid.GridData;
import re.belv.croiseur.solver.ginsberg.grid.InternalSlot;
import re.belv.croiseur.solver.ginsberg.grid.Puzzle;
import re.belv.croiseur.solver.ginsberg.grid.SlotData;
import re.belv.croiseur.solver.ginsberg.grid.SlotDefinition;
import re.belv.croiseur.solver.ginsberg.grid.SlotImpl;

final class GridImpl
implements Grid {
    private final Puzzle puzzle;
    private final GridData data;

    GridImpl(GridData someData) {
        this.data = someData;
        this.puzzle = new PuzzleImpl(someData);
    }

    @Override
    public Puzzle puzzle() {
        return this.puzzle;
    }

    @Override
    public Map<GridPosition, Character> boxes() {
        return this.data.toBoxes();
    }

    @Override
    public Set<GridPosition> slotPositions(Slot slot) {
        SlotDefinition slotDefinition = this.data.slots().get(slot.uid()).definition();
        HashSet<GridPosition> positions = new HashSet<GridPosition>();
        for (int i = slotDefinition.start(); i < slotDefinition.end(); ++i) {
            int column;
            int row;
            if (slotDefinition.type().isHorizontal()) {
                row = slotDefinition.offset();
                column = i;
            } else {
                row = i;
                column = slotDefinition.offset();
            }
            positions.add(new GridPosition(column, row));
        }
        return positions;
    }

    public String toString() {
        return this.data.toString();
    }

    private static final class PuzzleImpl
    implements Puzzle,
    Connectivity {
        private final GridData data;

        PuzzleImpl(GridData someData) {
            this.data = someData;
        }

        @Override
        public Collection<Slot> slots() {
            return this.data.slots().entrySet().stream().map(entry -> new SlotImpl((SlotIdentifier)entry.getKey(), (SlotData)entry.getValue(), this)).collect(Collectors.toList());
        }

        @Override
        public Slot slot(SlotIdentifier slotIdentifier) {
            return new SlotImpl(slotIdentifier, this.data.slot(slotIdentifier), this);
        }

        @Override
        public Stream<InternalSlot> connectedSlots(SlotIdentifier uid) {
            return this.data.connectedSlots(uid).stream().map(slotId -> new SlotImpl((SlotIdentifier)slotId, this.data.slot((SlotIdentifier)slotId), this));
        }

        @Override
        public boolean test(SlotIdentifier a, SlotIdentifier b) {
            return this.data.connectedSlots(a).contains(b);
        }

        @Override
        public Puzzle copy() {
            GridData dataCopy = this.data.copy();
            return new PuzzleImpl(dataCopy);
        }
    }
}

