/*
 * Decompiled with CFR 0.152.
 */
package re.belv.croiseur.solver.ginsberg.grid;

import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import re.belv.croiseur.solver.ginsberg.core.Slot;
import re.belv.croiseur.solver.ginsberg.core.SlotIdentifier;
import re.belv.croiseur.solver.ginsberg.grid.BoxData;
import re.belv.croiseur.solver.ginsberg.grid.Connectivity;
import re.belv.croiseur.solver.ginsberg.grid.InternalSlot;
import re.belv.croiseur.solver.ginsberg.grid.SlotData;
import re.belv.croiseur.solver.ginsberg.grid.SlotDefinition;

final class SlotImpl
implements InternalSlot {
    private final SlotData data;
    private final SlotIdentifier uid;
    private final Connectivity connectivity;

    SlotImpl(SlotIdentifier anUid, SlotData someData, Connectivity connectivityArg) {
        this.uid = anUid;
        this.data = someData;
        this.connectivity = connectivityArg;
    }

    @Override
    public SlotIdentifier uid() {
        return this.uid;
    }

    @Override
    public Optional<String> value() {
        return this.data.value();
    }

    @Override
    public String asPattern() {
        StringBuilder sb = new StringBuilder(this.data.length());
        for (int i = 0; i < this.data.length(); ++i) {
            BoxData box = this.data.boxAt(i);
            if (box.isEmpty()) {
                sb.append(' ');
                continue;
            }
            sb.append(box.value());
        }
        return sb.toString();
    }

    @Override
    public boolean isInstantiated() {
        return this.data.isInstantiated();
    }

    @Override
    public Stream<? extends Slot> connectedSlots() {
        return this.connectivity.connectedSlots(this.uid);
    }

    @Override
    public int emptyBoxRatio() {
        return this.data.emptyBoxRatio();
    }

    @Override
    public boolean isCompatibleWith(String value) {
        if (this.data.length() != value.length()) {
            return false;
        }
        for (int i = 0; i < this.data.length(); ++i) {
            BoxData box = this.data.boxAt(i);
            if (box.isEmpty() || box.value() == value.charAt(i)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void assign(String value) {
        this.data.write(value);
    }

    @Override
    public String unassign() {
        String clearedValue = this.value().orElseThrow(() -> new IllegalStateException("Illegal unassignment of non-instantiated variable"));
        SlotDefinition definition = this.data.definition();
        Set<Integer> boxesToKeep = this.connectivity.connectedSlots(this.uid).filter(Slot::isInstantiated).map(connectedSlot -> definition.connectionWith(connectedSlot.definition())).collect(Collectors.toSet());
        this.data.clearExcept(boxesToKeep);
        return clearedValue;
    }

    @Override
    public SlotDefinition definition() {
        return this.data.definition();
    }

    public String toString() {
        return "SlotImpl{data=" + String.valueOf(this.data) + ", uid=" + String.valueOf(this.uid) + "}";
    }
}

