/*
 * Decompiled with CFR 0.152.
 */
package re.belv.croiseur.solver.ginsberg.lookahead;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import re.belv.croiseur.solver.ginsberg.core.Slot;
import re.belv.croiseur.solver.ginsberg.core.SlotIdentifier;
import re.belv.croiseur.solver.ginsberg.dictionary.CachedDictionary;
import re.belv.croiseur.solver.ginsberg.elimination.EliminationSpace;
import re.belv.croiseur.solver.ginsberg.grid.Puzzle;
import re.belv.croiseur.solver.ginsberg.lookahead.Assignment;
import re.belv.croiseur.solver.ginsberg.lookahead.Unassignment;

public final class ProbePuzzle
implements Puzzle {
    private final Puzzle puzzle;
    private final CachedDictionary dictionary;
    private final EliminationSpace els;

    public ProbePuzzle(Puzzle puzzleArg, CachedDictionary dictionaryArg, EliminationSpace elsArg) {
        this.puzzle = puzzleArg.copy();
        this.dictionary = dictionaryArg;
        this.els = elsArg;
    }

    @Override
    public Collection<Slot> slots() {
        return this.puzzle.slots();
    }

    @Override
    public Slot slot(SlotIdentifier slotIdentifier) {
        return this.puzzle.slot(slotIdentifier);
    }

    @Override
    public ProbePuzzle copy() {
        return new ProbePuzzle(this.puzzle, this.dictionary, this.els);
    }

    public boolean hasSolutionAfter(Assignment assignment) {
        return this.computeNumberOfLocalSolutionsAfter(assignment).signum() > 0;
    }

    public BigInteger computeNumberOfLocalSolutionsAfter(Assignment assignment) {
        Slot probedSlot = this.puzzle.slot(assignment.slotUid());
        probedSlot.assign(assignment.word());
        BigInteger numberOfSolutions = probedSlot.connectedSlots().reduce(BigInteger.ONE, (previous, slot) -> previous.signum() == 0 ? previous : previous.multiply(BigInteger.valueOf(this.dictionary.candidates((Slot)slot).count())), BigInteger::multiply);
        probedSlot.unassign();
        return numberOfSolutions;
    }

    public boolean hasSolutionAfter(Unassignment unassignment, Slot unassignable) {
        return this.hasSolutionAfter(Collections.singletonList(unassignment), unassignable);
    }

    public boolean hasSolutionAfter(List<Unassignment> unassignments, Slot unassignable) {
        List<String> unassignedValues = this.unassign(unassignments);
        Set<String> probedEliminations = this.probeEliminationSpace(unassignments, unassignable);
        Slot probedSlot = this.puzzle.slot(unassignable.uid());
        boolean hasSolution = this.dictionary.reevaluatedCandidates(probedSlot).anyMatch(Predicate.not(probedEliminations::contains));
        this.reassign(unassignedValues, unassignments);
        return hasSolution;
    }

    private List<String> unassign(List<Unassignment> unassignments) {
        ArrayList<String> unassignedValues = new ArrayList<String>(unassignments.size());
        for (Unassignment unassignment : unassignments) {
            String unassignedValue = this.puzzle.slot(unassignment.slotUid()).unassign();
            unassignedValues.add(unassignedValue);
        }
        return unassignedValues;
    }

    private void reassign(List<String> unassignedValues, List<Unassignment> unassignments) {
        for (int i = 0; i < unassignments.size(); ++i) {
            this.puzzle.slot(unassignments.get(i).slotUid()).assign(unassignedValues.get(i));
        }
    }

    private Set<String> probeEliminationSpace(Collection<Unassignment> unassignments, Slot unassignable) {
        List<SlotIdentifier> modifiedVariables = unassignments.stream().map(Unassignment::slotUid).toList();
        HashMap<String, Set<SlotIdentifier>> refreshedEliminations = new HashMap<String, Set<SlotIdentifier>>(this.els.eliminations(unassignable.uid()));
        Iterator it = refreshedEliminations.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry elimination = it.next();
            Set reasons = (Set)elimination.getValue();
            if (Collections.disjoint(reasons, modifiedVariables)) continue;
            it.remove();
        }
        return refreshedEliminations.keySet();
    }
}

