/*
 * Decompiled with CFR 0.152.
 */
package re.belv.croiseur.solver.ginsberg.result;

import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import re.belv.croiseur.common.puzzle.GridPosition;
import re.belv.croiseur.solver.ginsberg.SolverResult;

final class SolverResultImpl
implements SolverResult {
    private static final char NOT_FILLED = '#';
    private static final char COLUMN_SEPARATOR = '|';
    private static final String LINE_SEPARATOR = System.lineSeparator();
    private final Map<GridPosition, Character> filledBoxes;
    private final Set<GridPosition> unsolvableBoxes;
    private final SolverResult.Kind kind;
    private final SolverResult.Statistics statistics;

    private SolverResultImpl(SolverResult.Kind kindArg, Map<GridPosition, Character> filledBoxesArg, Set<GridPosition> unsolvableBoxesArg, SolverResult.Statistics statisticsArg) {
        this.filledBoxes = filledBoxesArg;
        this.unsolvableBoxes = unsolvableBoxesArg;
        this.kind = kindArg;
        this.statistics = statisticsArg;
    }

    static SolverResultImpl success(Map<GridPosition, Character> solvedBoxes, SolverResult.Statistics statistics) {
        return new SolverResultImpl(SolverResult.Kind.SUCCESS, solvedBoxes, Collections.emptySet(), statistics);
    }

    static SolverResultImpl impossible(Map<GridPosition, Character> filledBoxes, Set<GridPosition> unsolvableBoxes, SolverResult.Statistics statistics) {
        return new SolverResultImpl(SolverResult.Kind.IMPOSSIBLE, filledBoxes, unsolvableBoxes, statistics);
    }

    @Override
    public SolverResult.Kind kind() {
        return this.kind;
    }

    @Override
    public Map<GridPosition, Character> filledBoxes() {
        return Collections.unmodifiableMap(this.filledBoxes);
    }

    @Override
    public Set<GridPosition> unsolvableBoxes() {
        return this.unsolvableBoxes;
    }

    @Override
    public SolverResult.Statistics statistics() {
        return this.statistics;
    }

    public String toString() {
        int width = this.filledBoxes.keySet().stream().map(coordinate -> coordinate.x() + 1).max(Comparator.naturalOrder()).orElse(0);
        int height = this.filledBoxes.keySet().stream().map(coordinate -> coordinate.y() + 1).max(Comparator.naturalOrder()).orElse(0);
        StringBuilder sb = new StringBuilder();
        sb.append("Result: ").append((Object)this.kind).append(LINE_SEPARATOR);
        sb.append("Filled boxes: ").append(this.filledBoxes).append(LINE_SEPARATOR);
        sb.append("Grid:").append(LINE_SEPARATOR);
        for (int y = 0; y < height; ++y) {
            sb.append('|');
            for (int x = 0; x < width; ++x) {
                Character value = this.filledBoxes.get(new GridPosition(x, y));
                if (value != null) {
                    sb.append(value);
                } else {
                    sb.append('#');
                }
                sb.append('|');
            }
            sb.append(LINE_SEPARATOR);
        }
        sb.append("Statistics: ").append(this.statistics).append(LINE_SEPARATOR);
        if (this.kind == SolverResult.Kind.IMPOSSIBLE) {
            sb.append("Unsolvable boxes: ").append(this.unsolvableBoxes).append(LINE_SEPARATOR);
        }
        return sb.toString();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof SolverResultImpl)) {
            return false;
        }
        SolverResultImpl otherSolverResultImpl = (SolverResultImpl)other;
        return this.filledBoxes.equals(otherSolverResultImpl.filledBoxes) && this.unsolvableBoxes.equals(otherSolverResultImpl.unsolvableBoxes) && this.kind == otherSolverResultImpl.kind && this.statistics.equals(otherSolverResultImpl.statistics);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.filledBoxes, this.unsolvableBoxes, this.kind, this.statistics});
    }
}

