/*
 * Decompiled with CFR 0.152.
 */
package re.belv.croiseur.solver.sat.plugin;

import java.lang.runtime.SwitchBootstraps;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.stream.Collectors;
import re.belv.croiseur.common.puzzle.GridPosition;
import re.belv.croiseur.common.puzzle.PuzzleGrid;
import re.belv.croiseur.solver.sat.Solver;
import re.belv.croiseur.spi.solver.CrosswordSolver;
import re.belv.croiseur.spi.solver.Dictionary;
import re.belv.croiseur.spi.solver.ProgressListener;
import re.belv.croiseur.spi.solver.SolverResult;

public final class SatSolver
implements CrosswordSolver {
    public String name() {
        return "SAT";
    }

    public String description() {
        return ResourceBundle.getBundle("re.belv.croiseur.solver.sat.plugin.Messages").getString("description");
    }

    public SolverResult solve(PuzzleGrid puzzle, Dictionary dictionary, ProgressListener progressListener) throws InterruptedException {
        progressListener.onInitialisationStart();
        char[][] inputGrid = SatSolver.convertToArray(puzzle);
        String[] words = SatSolver.filterAndConvertToArray(dictionary);
        Solver solver = new Solver(inputGrid, words);
        progressListener.onInitialisationEnd();
        Solver.Result result = solver.solve();
        progressListener.onSolverProgressUpdate((short)100);
        return new AdaptedSolverResult(result);
    }

    private static char[][] convertToArray(PuzzleGrid original) {
        char[][] adapted = new char[original.height()][original.width()];
        for (int row = 0; row < original.height(); ++row) {
            for (int column = 0; column < original.width(); ++column) {
                GridPosition pos = GridPosition.at((int)column, (int)row);
                adapted[row][column] = original.shaded().contains(pos) ? 35 : original.filled().getOrDefault(pos, Character.valueOf('.')).charValue();
            }
        }
        return adapted;
    }

    private static String[] filterAndConvertToArray(Dictionary dictionary) {
        return (String[])dictionary.words().stream().filter(word -> word.chars().allMatch(c -> c >= 65 && c <= 90)).toArray(String[]::new);
    }

    private static final class AdaptedSolverResult
    implements SolverResult {
        private final Solver.Result result;

        AdaptedSolverResult(Solver.Result solverResultArg) {
            this.result = solverResultArg;
        }

        public SolverResult.Kind kind() {
            return this.result instanceof Solver.Result.Sat ? SolverResult.Kind.SUCCESS : SolverResult.Kind.IMPOSSIBLE;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public Map<GridPosition, Character> filledBoxes() {
            int row;
            HashMap<GridPosition, Character> filledBoxes;
            char[][] grid;
            Map<GridPosition, Character> map;
            Solver.Result result = this.result;
            Objects.requireNonNull(result);
            Solver.Result result2 = result;
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Solver.Result.Unsat.class, Solver.Result.Sat.class}, (Solver.Result)result2, n)) {
                default: {
                    throw new MatchException(null, null);
                }
                case 0: {
                    Solver.Result.Unsat ignored = (Solver.Result.Unsat)result2;
                    map = Collections.emptyMap();
                    return map;
                }
                case 1: 
            }
            Solver.Result.Sat sat = (Solver.Result.Sat)result2;
            try {
                char[][] cArray;
                grid = cArray = sat.grid();
                filledBoxes = new HashMap<GridPosition, Character>();
                row = 0;
            }
            catch (Throwable throwable) {
                throw new MatchException(throwable.toString(), throwable);
            }
            while (true) {
                if (row >= grid.length) {
                    map = filledBoxes;
                    return map;
                }
                for (int column = 0; column < grid[row].length; ++column) {
                    char value = grid[row][column];
                    if (value == '#') continue;
                    filledBoxes.put(GridPosition.at((int)column, (int)row), Character.valueOf(value));
                }
                ++row;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public Set<GridPosition> unsolvableBoxes() {
            Set<Object> set;
            Solver.Result result = this.result;
            Objects.requireNonNull(result);
            Solver.Result result2 = result;
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Solver.Result.Sat.class, Solver.Result.Unsat.class}, (Solver.Result)result2, n)) {
                default: {
                    throw new MatchException(null, null);
                }
                case 0: {
                    Solver.Result.Sat ignored = (Solver.Result.Sat)result2;
                    set = Collections.emptySet();
                    return set;
                }
                case 1: 
            }
            Solver.Result.Unsat unsat = (Solver.Result.Unsat)result2;
            try {
                Set set2;
                Set nonAssignablePositions = set2 = unsat.nonAssignablePositions();
                set = nonAssignablePositions.stream().map(pos -> GridPosition.at((int)pos.column(), (int)pos.row())).collect(Collectors.toSet());
                return set;
            }
            catch (Throwable throwable) {
                throw new MatchException(throwable.toString(), throwable);
            }
        }
    }
}

